<?php

namespace Iqonic\Elementor\Elements\FooterNavigation;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_footer_navigation';
    }

    public function get_title()
    {
        return __('Footer Navigation Menu', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-nav-menu';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_header',
            [
                'label' => __('Navigation', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'ft_nav_style',
            [
                'label'      => __('Style', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'ft-nav-style-one',
                'options'    => [
                    'ft-nav-style-one'      => __('Style 1', 'streamit-extensions'),
                    'ft-nav-style-two'      => __('Style 2', 'streamit-extensions'),
                    'ft-nav-style-three'      => __('Style 3', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_control(
            'direction',
            [
                'label'      => __('Direction', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'vertical',
                'options'    => [
                    'horizontal'    => __('Horizontal', 'streamit-extensions'),
                    'vertical'      => __('Vertical', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_control(
            'column_gap',
            [
                'label'      => __('Column Gap', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => '1',
                'options'    => [
                    '1'    => __('1', 'streamit-extensions'),
                    '2'      => __('2', 'streamit-extensions'),
                    '3'      => __('3', 'streamit-extensions'),
                ],
                'condition' => ['direction' => 'vertical'],
                'prefix_class' => 'iqonic-footer-gap-',
            ]
        );

        $this->add_control(
            'menu',
            [
                'label'     => __('Menu', 'streamit-extensions'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'select',
                'options'   =>  function_exists('layout_get_nav_menus') ? layout_get_nav_menus() : "",
            ]
        );

        $this->add_control(
            'has_icon',
            [
                'label' => __('Use Icon?', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'streamit-extensions'),
                'no' => __('no', 'streamit-extensions'),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'streamit-extensions'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'start'    => [
                        'title' => __('Left', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => __('Right', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .widget-nav-menu ul.layout-footer-widget' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        require 'style.php';
    }

    protected function render()
    {
        require 'render.php';
    }
}
