<?php

$image_alt  = get_the_title($cast_id);
$terms      = get_the_terms($cast_id, 'person_cat');

if (has_post_thumbnail($cast_id)) {
    $slider_image = wp_get_attachment_image_src(get_post_thumbnail_id($cast_id), 'full')[0];
}

if (isset($lazy_load) && !empty($lazy_load)) {
    $img_class      = ' iqonic-lazy';
    $lazy_image     = get_lazy_load_image();

    $original_image = $slider_image;
    $slider_image   = $lazy_image;
    $srcset         = "data-srcset=" . $original_image . "";
} else {
    $img_class = '';
    $srcset = '';
}
?>

<li class="slide-item">
    <div class="block-image position-relative">
        <?php if (isset($slider_image) && !empty($slider_image)) { ?>
            <div class="img-box">
                <a href="<?php echo get_the_permalink($cast_id); ?>">
                    <img src="<?php echo esc_url($slider_image) ?>" class="img-fluid <?php echo esc_attr($img_class); ?>" alt="<?php echo $image_alt; ?>" <?php echo esc_attr($srcset); ?>>
                </a>
            </div>
        <?php } ?>

        <div class="card-description">
            <div class="cart-content">
                <div class="content-left">
                    <h5 class="iq-title">
                        <a href="<?php echo get_the_permalink($cast_id) ?>" tabindex="0">
                            <?php echo get_the_title($cast_id); ?>
                        </a>
                    </h5>

                    <?php if ($terms) : ?>
                        <span>
                            <a href="<?php echo get_term_link($terms[0]->term_id); ?>">
                                <?php echo esc_html($terms[0]->name); ?>
                            </a>
                        </span>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</li>