<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$view_all = '';
$args = $post_ids = $tax_query = $taxargs = array();
$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

$settings 		= $this->get_settings();
$slider_title 	= $settings['section_title'];

$lazy_load = $settings['enable_lazy_load_images'] == "yes" ? " iqonic-lazy-load-images" : "";

if ($settings['use_custom_link_viewall'] == 'yes') {
	$view_all_text = esc_html($settings['use_custom_link_text']);

	$this->add_render_attribute('iq_class', 'class', 'iq-view-all');
	if ($settings['view_all_custom_link']['url']) {
		$url = $settings['view_all_custom_link']['url'];
		$this->add_render_attribute('iq_class', 'href', esc_url($url));

		if ($settings['view_all_custom_link']['is_external']) {
			$this->add_render_attribute('iq_class', 'target', '_blank');
		}

		if ($settings['view_all_custom_link']['nofollow']) {
			$this->add_render_attribute('iq_class', 'rel', 'nofollow');
		}
	}
	$view_all = '<a ' . $this->get_render_attribute_string('iq_class') . '">' . $view_all_text . '</a>';
}

$this->add_render_attribute('slider', 'data-nav', 				$settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-items', 			$settings['desk_number']);
$this->add_render_attribute('slider', 'data-items-laptop', 		$settings['lap_number']);
$this->add_render_attribute('slider', 'data-items-tab', 		$settings['tab_number']);
$this->add_render_attribute('slider', 'data-items-mobile', 		$settings['mob_number']);
$this->add_render_attribute('slider', 'data-items-mobile-sm', 	$settings['mob_number']);
$this->add_render_attribute('slider', 'data-autoplay', 			$settings['autoplay']);
$this->add_render_attribute('slider', 'data-autoplay-speed', 	$settings['autoplay_speed']);
$this->add_render_attribute('slider', 'data-infinite', 			$settings['infinite']);
$this->add_render_attribute('slider', 'data-speed', 			$settings['speed']);

$user_meta = (array) json_decode(get_user_meta(get_current_user_id(), '_watch_content', true)); ?>

<div class="streamit-favourite-personality <?php echo esc_attr($lazy_load); ?>">
	<div class="streamit-title">
		<?php if (!empty($slider_title)) { ?>
			<div class="iq-main-header d-flex align-items-center justify-content-between">
				<<?php echo esc_html($settings['title_tag']); ?> class="main-title">
					<?php echo esc_html($slider_title); ?>
				</<?php echo esc_html($settings['title_tag']); ?>>

				<?php if (!empty($view_all)) echo $view_all; ?>
			</div>
		<?php } ?>
	</div>

	<ul class="favorites-slider p-0 row iq-rtl-direction <?php echo isset($settings['nav-arrow-style']) && $settings['nav-arrow-style'] == 'style-2' ? 'iq-arrow-2' : ''; ?>" <?php echo $this->get_render_attribute_string('slider'); ?>>
		<?php if ($settings['post_filter'] == "default") {
			$cast_id = [];
			if (isset($user_meta) && !empty($user_meta)) {
				$unique_cast_ids = array();
				foreach ($user_meta as $post_id => $value) {
					$movie_cast = get_post_meta($post_id, '_cast', true);
					if (is_array($movie_cast)) {
						$cast_id = array_merge($cast_id, array_column($movie_cast, "id"));
					}
				}

				$unique_cast_ids = array_unique($cast_id);

				foreach ($unique_cast_ids as $cast_id) {
					require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
				}
			}
		} elseif ($settings['post_filter'] == "selected") {
			$tabs = $settings['tabs'];
			foreach ($tabs as $cast) {
				$post_slug = $cast['iq_cast_id'];

				if (isset($post_slug) && !empty($post_slug)) :
					$post 		=	get_page_by_path($post_slug, OBJECT, 'person');
					$cast_id 	= ($post)  ? $post->ID : '';

					if (!empty($cast_id))
						require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
				endif;
			}
		}
		?>
	</ul>
</div>