<?php

namespace Iqonic\Elementor\Elements\Favourite_Personality;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Repeater;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_favourite_personality';
	}

	public function get_title()
	{
		return esc_html__('Iqonic Favourite Personality', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_Team',
			[
				'label' => __('Favourite Personality', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'section_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Title', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Title Tag', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'h1'          => __('h1', 'streamit-extensions'),
					'h2'          => __('h2', 'streamit-extensions'),
					'h3'          => __('h3', 'streamit-extensions'),
					'h4'          => __('h4', 'streamit-extensions'),
					'h5'          => __('h5', 'streamit-extensions'),
					'h6'          => __('h6', 'streamit-extensions'),
				],
				'default'    => 'h4',
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __('Posts Filter', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => false,
				'options' => [
					'selected' 	=> __('Selected', 'streamit-extensions'),
					'default' 	=> __('Default', 'streamit-extensions')
				],
				'default' => 'default'
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label'         => __('Lazy Load Images', 'streamit-extensions'),
				'type'          => Controls_Manager::SWITCHER,
				'yes'           => __('Yes', 'streamit-extensions'),
				'no'            => __('No', 'streamit-extensions'),
				'return_value'  => 'yes',
				'default'       => 'no',
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'iq_cast_id',
			[
				'label' => __('Select Cast Name', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('person') : [],
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => __('Select posts manually', 'streamit-extensions'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'condition' => ['post_filter' => 'selected']
			]
		);

		$this->add_control(
			'use_custom_link_viewall',
			[
				'label' => __('Use View All custom link ?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __('Yes', 'streamit-extensions'),
				'no' => __('No', 'streamit-extensions'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'use_custom_link_text',
			[
				'label' => __('Custom Link Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('View All', 'streamit-extensions'),
				'label_block' => true,
				'condition' => [
					'use_custom_link_viewall' => 'yes',
				],
			]
		);

		$this->add_control(
			'view_all_custom_link',
			[
				'label' => __('Custom link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'placeholder' => __('https://your-link.com', 'streamit-extensions'),
				'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
				],
				'condition' => [
					'use_custom_link_viewall' => 'yes',
				],
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/slick-control.php';

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callSlickSlider(jQuery('.favorites-slider'));
				})(jQuery)
			</script>
<?php
		}
	}
}
