<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

$this->start_controls_section(
    'section_title_style',
    [
        'label' => __('Title', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'title_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .iq-main-header .main-title',
    ]
);

$this->start_controls_tabs('icon_tabs');
$this->start_controls_tab(
    'tabs_color_normal',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'title_color_normal',
    [
        'label' => __('Text Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-main-header .main-title' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'title_bg_color_normal',
    [
        'label' => __('Background Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-main-header .main-title' => 'background: {{VALUE}};',
        ],
    ]
);
$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_color_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'title_color_hover',
    [
        'label' => __('Text Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-main-header .main-title:hover' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'title_bg_color_hover',
    [
        'label' => __('Background Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-main-header .main-title:hover' => 'background: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'title_padding',
    [
        'label' => __('Padding', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-main-header .main-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'title_margin',
    [
        'label' => __('Margin', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .iq-main-header .main-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$this->end_controls_section();
