<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();

$this->add_render_attribute('slider-wrapper', 'class', "iq_movie-contents favorites-contens streamit_datapass_movie streamit-continue-watching");

if ($settings['watching_style'] == '2')
    $this->add_render_attribute('slider-wrapper', 'class', "minimal-detail");

$lazy_load    = $settings['enable_lazy_load_images'] == "yes" ? "iqonic-lazy-load-images" : "";
$this->add_render_attribute('slider-wrapper', 'class', $lazy_load);

$this->add_render_attribute('slider', 'data-nav',               $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-items',             $settings['desk_number']);
$this->add_render_attribute('slider', 'data-items-laptop',      $settings['lap_number']);
$this->add_render_attribute('slider', 'data-items-tab',         $settings['tab_number']);
$this->add_render_attribute('slider', 'data-items-mobile',      $settings['mob_number']);
$this->add_render_attribute('slider', 'data-items-mobile-sm',   $settings['mob_number']);
$this->add_render_attribute('slider', 'data-autoplay',          $settings['autoplay']);
$this->add_render_attribute('slider', 'data-autoplay-speed',    $settings['autoplay_speed']);
$this->add_render_attribute('slider', 'data-infinite',          $settings['infinite']);
$this->add_render_attribute('slider', 'data-speed',             $settings['speed']);

$watchedMeta = (array) json_decode(get_user_meta(get_current_user_id(), '_watch_content', true));

if (!is_user_logged_in() || empty($watchedMeta)) return; ?>

<div <?php echo $this->get_render_attribute_string('slider-wrapper'); ?>>
    <div class="iq-main-header d-flex align-items-center justify-content-between">
        <<?php echo esc_attr($settings['title_tag']); ?> class="main-title">
            <?php echo esc_html($settings['slider_title']); ?>
        </<?php echo esc_attr($settings['title_tag']); ?>>
    </div>

    <ul class="favorites-slider continue-watching-slider mb-0 p-0 row <?php echo isset($settings['nav-arrow-style']) && $settings['nav-arrow-style'] == 'style-2' ? 'iq-arrow-2' : ''; ?> <?php echo (count($watchedMeta) > 4) ? 'iq-rtl-direction ' : '';  ?>" <?php echo $this->get_render_attribute_string('slider'); ?>>
        <?php if ($settings['watching_style'] == '1') {
            do_shortcode('[streamit_continue_watching_slider style=1 lazy_load=' . $lazy_load . ']');
        } else {
            do_shortcode('[streamit_continue_watching_slider style=2 lazy_load=' . $lazy_load . ']');
        } ?>
    </ul>
</div>