<?php

namespace Iqonic\Elementor\Elements\ContinueWatching;

use Elementor\Plugin;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_continue_watching';
	}

	public function get_title()
	{
		return esc_html__('Continue Watching', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-push';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_watching',
			[
				'label' => __('Continue Watching', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'watching_style',
			[
				'label'      => __('Select Style', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'1'      => __('Style 1', 'streamit-extensions'),
					'2'      => __('Style 2', 'streamit-extensions'),
				],
				'default'    => '2',
			]
		);

		$this->add_control(
			'slider_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Title', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Title Tag', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'options'    => [
					'h1'          => __('h1', 'streamit-extensions'),
					'h2'          => __('h2', 'streamit-extensions'),
					'h3'          => __('h3', 'streamit-extensions'),
					'h4'          => __('h4', 'streamit-extensions'),
					'h5'          => __('h5', 'streamit-extensions'),
					'h6'          => __('h6', 'streamit-extensions'),
				],
				'default'    => 'h4',
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label' => __('Lazy Load Images', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'slick_control_section',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
			]
		);

		require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/slick-control.php';

		$this->end_controls_section();

		require 'style.php';
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callSlickSlider(jQuery('.favorites-slider'));
				})(jQuery)
			</script>
<?php
		}
	}
}
