<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
if (!class_exists('WooCommerce')) return;

$settings = $this->get_settings();
$orderby  = $settings['woo_order_by'];

$args = array(
    'taxonomy'      => 'product_cat',
    'show_count'    => 0,
    'pad_counts'    => 0,
    'hierarchical'  => 1,
    'title_li'      => '',
    'hide_empty'    => 1,
    'orderby'       => $orderby,
    "order"         => $settings['woo_order'],
);

if ($settings['woo_cat_data'] !== 'dynamic') {
    $tabs = $settings['tabs'];
    foreach ($tabs as $index => $item) {
        $cate_list[] = $item['category_title_list'];
    }
    $args['slug']       = $cate_list;
    $args['order']      = 'ASC';
    $args['orderby']    = 'slug__in';
}

$woo_categories = get_categories($args);

$this->add_render_attribute('slider', 'data-nav',               $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-items',             $settings['desk_number']);
$this->add_render_attribute('slider', 'data-items-laptop',      $settings['lap_number']);
$this->add_render_attribute('slider', 'data-items-laptop-lg',   $settings['lap_extra_number']);
$this->add_render_attribute('slider', 'data-items-tab',         $settings['tab_number']);
$this->add_render_attribute('slider', 'data-items-mobile',      $settings['mob_number']);
$this->add_render_attribute('slider', 'data-items-mobile-sm',   $settings['mob_number']);
$this->add_render_attribute('slider', 'data-autoplay',          $settings['autoplay']);
$this->add_render_attribute('slider', 'data-autoplay-speed',    $settings['autoplay_speed']);
$this->add_render_attribute('slider', 'data-loop',              $settings['infinite']);
$this->add_render_attribute('slider', 'data-center',            'false');
$this->add_render_attribute('slider', 'data-touchdrag',         'true');
$this->add_render_attribute('slider', 'data-mousedrag',         'true'); ?>

<div class="streamit-category-style-<?php echo esc_attr($settings['design_style']); ?> streamit-product-cat-slick iq-rtl-direction" <?php echo $this->get_render_attribute_string('slider') ?>>
    <?php if ($woo_categories) {
        foreach ($woo_categories as $cat) {
            if (empty($cat->term_id)) continue;

            $term_link      = get_term_link($cat);
            $thumbnail_id   = get_term_meta($cat->term_id, 'thumbnail_id', true);
            $image_url      = empty($thumbnail_id) ?  (STREAMIT_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/img/placeholder_genre.jpg') : wp_get_attachment_url($thumbnail_id); ?>

            <div class="streamit-categories">
                <div class="streamit-category-inner">
                    <div class="category_image">
                        <?php if (!empty($image_url)) { ?>
                            <a href="<?php echo esc_url($term_link); ?>">
                                <?php if (empty($thumbnail_id)) {
                                    echo '<img class="cat-img img-fluid" src="' . esc_url($image_url) . ' " alt="Image" />';
                                } else {
                                    echo wp_get_attachment_image($thumbnail_id, 'medium');
                                } ?>
                            </a>
                        <?php } ?>

                        <div class="streamit-category-details">
                            <?php if (!empty($cat->name)) { ?>
                                <<?php echo $settings['title_tag'];  ?> class="streamit-title">
                                    <a href="<?php echo esc_url($term_link); ?>">
                                        <?php echo esc_html($cat->name); ?>
                                    </a>
                                </<?php echo $settings['title_tag']; ?>>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
    <?php }
    } ?>
</div>