<?php

namespace Iqonic\Elementor\Elements\Category_Slider;

use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_product_category_slider', 'streamit-extensions');
    }

    public function get_title()
    {
        return __('WooCommerce Product Category Slider', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-slider-album';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_blog',
            [
                'label' => __('Category', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'      => __('Select Style', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'options'    => [
                    'rounded'          => __('Rounded', 'streamit-extensions'),
                    'square'          => __('Square', 'streamit-extensions'),
                    'circle'          => __('Circle', 'streamit-extensions'),
                ],
                'default'    => 'square',
            ]
        );

        $this->add_control(
            'woo_cat_data',
            [
                'label'      => __('Select Category', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'options'    => [
                    'dynamic'          => __('Dynamic', 'streamit-extensions'),
                    'static'          => __('Static', 'streamit-extensions'),
                ],
                'default'    => 'dynamic',
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'category_title_list',
            [
                'label' => __('Choose Category', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'multiple' => true,
                'options' => isset($_REQUEST['editor_post_id']) ? iqonic_get_taxonomies('product_cat') : [],
            ]
        );

        $repeater->add_responsive_control(
            'cat_content_align',
            [
                'label' => __('Alignment', 'streamit-extensions'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .streamit-category-details' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $repeater->add_responsive_control(
            'cat_content_color',
            [
                'label' => __('Text Color', 'streamit-extensions'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} {{CURRENT_ITEM}} .streamit-category-details .streamit-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => __('Lists Items', 'streamit-extensions'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition' => ['woo_cat_data' => 'static'],
            ]
        );

        $this->add_control(
            'woo_order_by',
            [
                'label'   => __('Order By', 'streamit-extensions'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'menu_order' => esc_html__('Menu Order', 'streamit-extensions'),
                    'title' => esc_html__('Title', 'streamit-extensions'),
                    'date' => esc_html__('Date', 'streamit-extensions'),
                    'rand' => esc_html__('Rand', 'streamit-extensions'),
                    'id' => esc_html__('Id', 'streamit-extensions')
                ],
                'condition' => ['woo_cat_data!' => 'static'],
            ]
        );

        $this->add_control(
            'woo_order',
            [
                'label'   => __('Order', 'streamit-extensions'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'DESC' => esc_html__('Descending', 'streamit-extensions'),
                    'ASC' => esc_html__('Ascending', 'streamit-extensions')
                ],
                'condition' => ['woo_cat_data!' => 'static'],
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'      => __('Title Tag', 'streamit-extensions'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'h5',
                'options'    => [
                    'h1'          => __('h1', 'streamit-extensions'),
                    'h2'          => __('h2', 'streamit-extensions'),
                    'h3'          => __('h3', 'streamit-extensions'),
                    'h4'          => __('h4', 'streamit-extensions'),
                    'h5'          => __('h5', 'streamit-extensions'),
                    'h6'          => __('h6', 'streamit-extensions'),
                ],
            ]
        );

        $this->add_responsive_control(
            'content_align',
            [
                'label' => __('Alignment', 'streamit-extensions'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .streamit-category-details' => 'text-align: {{VALUE}};',
                ],
                'condition' => ['woo_cat_data!' => 'static'],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'slider_control_section',
            [
                'label' => __('Slider Control', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'laptop_extra_view',
            [
                'label' => esc_html__('View', 'plugin-name'),
                'type' => Controls_Manager::HIDDEN,
                'default' => 'yes',
            ]
        );

        require STREAMIT_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/slick-control.php';

        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';
        if (Plugin::$instance->editor->is_edit_mode()) { ?>
            <script>
                (function(jQuery) {
                    callSlider(jQuery('.streamit-product-cat-slick'));
                })(jQuery);
            </script>
<?php
        }
    }
}
