<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

$this->start_controls_section(
    'section_cat_title',
    [
        'label' => esc_html__('Main Category', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_responsive_control(
    'cat_title_padding',
    [
        'label' => esc_html__('Padding', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .streamit-product-box  .streamit-parent-heading' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'cat_title_margin',
    [
        'label' => esc_html__('Margin', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .streamit-product-box  .streamit-parent-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'cat_title_color',
    [
        'label' => esc_html__('Choose Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .streamit-product-box  .streamit-parent-heading' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'cat_title_hover_color',
    [
        'label' => esc_html__('Choose Hover Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .streamit-product-box:hover  .streamit-parent-heading' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'cat_title_typography',
        'label' => esc_html__('Typography', SE_TEXT_DOMAIN),
        'selector' => '{{WRAPPER}}  .streamit-product-box  .streamit-parent-heading',
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_cat_sub_title',
    [
        'label' => esc_html__('Parent Category', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_responsive_control(
    'cat_sub_title_padding',
    [
        'label' => esc_html__('Padding', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .streamit-product-box  .card-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'cat_sub_title_margin',
    [
        'label' => esc_html__('Margin', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%', 'em'],
        'selectors' => [
            '{{WRAPPER}} .streamit-product-box  .card-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'cat_sub_title_color',
    [
        'label' => esc_html__('Choose Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .streamit-product-box  .card-title' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'cat_sub_title_hover_color',
    [
        'label' => esc_html__('Choose Hover Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .streamit-product-box:hover  .card-title' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'cat_sub_title_typography',
        'label' => esc_html__('Typography', SE_TEXT_DOMAIN),
        'selector' => '{{WRAPPER}}  .streamit-product-box  .card-title',
    ]
);

$this->end_controls_section();
