<?php

namespace Elementor;

if (!class_exists('WooCommerce')) {
    return;
}

$image_url  = '';
$settings   = $this->get_settings();
$perent_id  = is_numeric($settings['category_title_list'])  ?  get_term($settings['category_title_list']) : get_term_by('slug', $settings['category_title_list'], 'product_cat');

if ($settings['add_custom_image'] == 'yes') {
    $image_url = $settings['cat_image']['url'];
} else {
    if (!empty($perent_id) && $perent_id->term_id != 0) {
        $thumbnail_id = get_term_meta($perent_id->term_id, 'thumbnail_id', true);
    } else {
        $thumbnail_id = get_term_meta($perent_id, 'thumbnail_id', true);
    }
    $image_url = wp_get_attachment_url($thumbnail_id);
} ?>

<div class="streamit-product-box ">
    <a href="<?php echo esc_url(get_term_link($perent_id)) ?>" class="streamit-card-link"></a>
    <div class="streamit-card-img-overlay" style="background-image: url(<?php echo esc_url($image_url) ?>)"> </div>

    <div class="streamit-card-body w-100">
        <?php if ($perent_id->parent != 0) { ?>
            <h5 class="card-title"><?php echo $perent_id->name ?> </h5>
        <?php } ?>

        <h4 class="streamit-parent-heading">
            <?php $term = get_term($perent_id->parent != 0 ? $perent_id->parent : $perent_id);
            echo $term->name; ?>
        </h4>

        <?php if ($settings['button_text']) {
            $bnt_link_tag = 'span';
            require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/iqonic-btn-dynamic-render.php';
        } ?>
    </div>
</div>