<?php

namespace Iqonic\Elementor\Elements\Category_Box;

use Elementor\Utils;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;
class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_product_category_box', 'streamit-extensions');
    }

    public function get_title()
    {
        return __('WooCommerce Product Category Box', 'streamit-extensions');
    }
    public function get_categories()
    {
        return ['streamit-extension'];
    }

    public function get_icon()
    {
        return 'eicon-image-box';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_blog',
            [
                'label' => __('Product Category Box', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'category_title_list',
            [
                'label' => __('Choose Category', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'label_block' => true,
                'multiple' => true,
                'options' => isset($_REQUEST['editor_post_id']) ? iqonic_get_all_taxonomies('product_cat') : [],
            ]
        );

        $this->add_control(
            'add_custom_image',
            [
                'label' => esc_html__('Add Custom Image', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('yes', 'streamit-extensions'),
                'label_off' => esc_html__('No', 'streamit-extensions'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'cat_image',
            [
                'label' => esc_html__('Choose Image', 'streamit-extensions'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => ['add_custom_image' => 'yes'],
            ]
        );

        $this->add_responsive_control(
            'cat_content_align',
            [
                'label' => __('Alignment', 'streamit-extensions'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'streamit-extensions'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-product-box  .streamit-card-img-overlay' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'box_height',
            [
                'label' => esc_html__('Height', 'streamit-extensions'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 500,
                ],
                'selectors' => [
                    '{{WRAPPER}} .streamit-product-box' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        require 'style.php';
        require STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Elementor/Controls/iqonic-btn-dynamic-controls.php';
    }

    protected function render()
    {
        require 'render.php';
    }
}
