<?php

use Elementor\Controls_Manager;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

$this->start_controls_section(
    'section_icon_style',
    [
        'label' => __('Icon', 'streamit-extensions'),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'btn_size',
    [
        'label' => esc_html__('Button Size', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 500,
                'step' => 1,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
            'em' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'default' => [
            'unit' => 'px',
            'size' => 50,
        ],
        'selectors' => [
            '{{WRAPPER}} .cart-btn .streamit-cart a' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'btn_radius',
    [
        'label' => esc_html__('Button Radius', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%', 'em'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 500,
                'step' => 1,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ]
        ],
        'default' => [
            'unit' => 'px',
            'size' => 50,
        ],
        'selectors' => [
            '{{WRAPPER}} .cart-btn .streamit-cart a' => 'border-radius: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->start_controls_tabs('icon_tabs');
$this->start_controls_tab(
    'tabs_icon_normal',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'icon_bg_color',
    [
        'label' => __('Choose Background Color ', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'icon_color',
    [
        'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-cart svg,{{WRAPPER}} .streamit-cart i,{{WRAPPER}} .streamit-cart svg path, {{WRAPPER}} .streamit-cart i, {{WRAPPER}} .streamit-cart svg path' => 'fill: {{VALUE}}; color: {{VALUE}};'
        ],
    ]
);

$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_icon_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'icon_hover_bg_color',
    [
        'label' => __('Choose Background Hover Color ', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart:hover' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'icon_hover_color',
    [
        'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart:hover svg,{{WRAPPER}} .streamit-cart .dropdown-cart:hover svg path,{{WRAPPER}} .streamit-cart .dropdown-cart:hover i' => 'fill: {{VALUE}}; color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'icon_size',
    [
        'label' => __('Icon Size', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart i,{{WRAPPER}} .streamit-cart svg' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'icon_width',
    [
        'label' => __('Width', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart svg,{{WRAPPER}} .streamit-cart i, {{WRAPPER}} .streamit-cart svg' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'icon_height',
    [
        'label' => __('Height', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', 'em', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart svg,{{WRAPPER}} .streamit-cart i, {{WRAPPER}} .streamit-cart svg' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_count_style',
    [
        'label' => __('Count', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->start_controls_tabs('count_tabs');
$this->start_controls_tab(
    'tabs_count_normal',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'count_color',
    [
        'label' => __('Choose color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart .count, {{WRAPPER}} .streamit-cart .basket-item-count .cart-items-count.count' => 'color: {{VALUE}};'
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'streamit_count_background',
        'label' => __('Background', 'streamit-extensions'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}} .streamit-cart .dropdown-cart .count, {{WRAPPER}} .basket-item-count',
    ]
);

$this->add_control(
    'streamit_icon_has_border',
    [
        'label' => __('Set Custom Border?', 'streamit-extensions'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'streamit-extensions'),
        'no' => __('no', 'streamit-extensions'),
    ]
);

$this->add_control(
    'streamit_icon_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'type' => Controls_Manager::SELECT,
        'condition' => ['streamit_icon_has_border' => ['yes']],
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart .count' => 'border-style:{{VALUE}};',
        ],
    ]
);

$this->add_control(
    'streamit_icon_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'condition' => ['streamit_icon_has_border' => ['yes']],
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart .count' => 'border-color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'streamit_icon_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'condition' => ['streamit_icon_has_border' => ['yes']],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart .count' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'streamit_icon_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'condition' => ['streamit_icon_has_border' => ['yes']],
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart .count' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);
$this->end_controls_tab();

$this->start_controls_tab(
    'tabs_count_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'count_hover_color',
    [
        'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}}  .streamit-cart .dropdown-cart:hover .count' => 'fill: {{VALUE}}; color: {{VALUE}};',
        ],
    ]
);

$this->add_group_control(
    Group_Control_Background::get_type(),
    [
        'name' => 'streamit_count_hover_background',
        'label' => __('Hover Background', 'streamit-extensions'),
        'types' => ['classic', 'gradient'],
        'selector' => '{{WRAPPER}}  .streamit-cart .dropdown-cart:hover .count',
    ]
);

$this->add_control(
    'streamit_count_hover_has_border',
    [
        'label' => __('Set Custom Border?', 'streamit-extensions'),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'no',
        'yes' => __('yes', 'streamit-extensions'),
        'no' => __('no', 'streamit-extensions'),
    ]
);

$this->add_control(
    'streamit_icon_hover_border_style',
    [
        'label' => __('Border Style', 'streamit-extensions'),
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', 'streamit-extensions'),
            'dashed' => __('Dashed', 'streamit-extensions'),
            'dotted' => __('Dotted', 'streamit-extensions'),
            'double' => __('Double', 'streamit-extensions'),
            'outset' => __('outset', 'streamit-extensions'),
            'groove' => __('groove', 'streamit-extensions'),
            'ridge' => __('ridge', 'streamit-extensions'),
            'inset' => __('inset', 'streamit-extensions'),
            'hidden' => __('hidden', 'streamit-extensions'),
            'none' => __('none', 'streamit-extensions'),
        ],
        'condition' => ['streamit_count_hover_has_border' => ['yes']],
        'selectors' => [
            '{{WRAPPER}}  .streamit-cart .dropdown-cart:hover .count' => 'border-style:{{VALUE}};',
        ],
    ]
);

$this->add_control(
    'streamit_icon_hover_border_color',
    [
        'label' => __('Border Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'condition' => ['streamit_count_hover_has_border' => ['yes']],
        'selectors' => [
            '{{WRAPPER}}  .streamit-cart .dropdown-cart:hover .count' => 'border-color: {{VALUE}};',
        ],
    ]
);


$this->add_control(
    'streamit_icon_hover_border_width',
    [
        'label' => __('Border Width', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'condition' => ['streamit_count_hover_has_border' => ['yes']],
        'selectors' => [
            '{{WRAPPER}}  .streamit-cart .dropdown-cart:hover .count' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_control(
    'streamit_icon_hover_border_radius',
    [
        'label' => __('Border Radius', 'streamit-extensions'),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'condition' => ['streamit_count_hover_has_border' => ['yes']],
        'selectors' => [
            '{{WRAPPER}}  .streamit-cart .dropdown-cart:hover .count' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'count_size',
    [
        'label' => __('Font Size', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart .count' => 'font-size: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'count_width',
    [
        'label' => __('Width', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart .count' => 'width: {{SIZE}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'count_height',
    [
        'label' => __('Height', 'streamit-extensions'),
        'type' => Controls_Manager::SLIDER,
        'size_units' => ['px', '%'],
        'range' => [
            'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 5,
            ],
            '%' => [
                'min' => 0,
                'max' => 100,
            ],
        ],
        'selectors' => [
            '{{WRAPPER}} .streamit-cart .dropdown-cart .count' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
        ],
    ]
);
$this->end_controls_section();

$this->start_controls_section(
    'section_cart_title_style',
    [
        'label' => __('Title', 'streamit-extensions'),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name' => 'mobile_typography',
        'label' => __('Typography', 'streamit-extensions'),
        'selector' => '{{WRAPPER}} .streamit-cart-text',
    ]
);

$this->start_controls_tabs('title_tabs');

$this->start_controls_tab(
    'title_color_tab_normal',
    [
        'label' => __('Normal', 'streamit-extensions'),
    ]
);

$this->add_control(
    'title_normal_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-cart-text' => 'color: {{VALUE}};',
        ],
    ]
);
$this->end_controls_tab();
$this->start_controls_tab(
    'title_color_tab_hover',
    [
        'label' => __('Hover', 'streamit-extensions'),
    ]
);

$this->add_control(
    'title_hover_color',
    [
        'label' => __('Color', 'streamit-extensions'),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .streamit-cart-text' => 'color: {{VALUE}};',
        ],
    ]
);
$this->end_controls_tab();
$this->end_controls_tabs();
$this->end_controls_section();
