<?php

namespace Iqonic\Elementor\Elements\Cart;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_cart';
    }

    public function get_title()
    {
        return __('Layouts: Cart', SE_TEXT_DOMAIN);
    }

    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-cart';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_sc_layouts_cart',
            [
                'label' => __('Layouts: Cart', SE_TEXT_DOMAIN),
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => __('Icon', SE_TEXT_DOMAIN),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-shopping-cart',
                    'library' => 'solid',
                ],
            ]
        );

        $this->end_controls_section();

       require 'style.php';

        
    }

    protected function render()
    {
        if ( class_exists( 'WooCommerce' ) ) {
            require 'render.php';
        }
    }
}
