<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$html = $align = $icon = $modalid = '';
$settings = $this->get_settings();
$button_action = isset($settings['button_action']) && !empty($settings['button_action']) ? $settings['button_action'] : '';

$this->add_render_attribute('iq_class', 'class', 'iq-button btn btn-hover');

if (isset($settings['btn_has_box_shadow']) && $settings['btn_has_box_shadow'] == 'yes') {
    $this->add_render_attribute('iq_class', 'class', 'iq-box-shadow');
}

$html .= esc_html($settings['button_text']);

if (isset($settings['button_size']) && $settings['button_size'] != 'default') {
    $this->add_render_attribute('iq_class', 'class', esc_attr($settings['button_size']));
}

if (isset($settings['button_shape']) && $settings['button_shape'] != 'default') {
    $this->add_render_attribute('iq_class', 'class', esc_attr($settings['button_shape']));
}

if (isset($settings['button_style']) && $settings['button_style'] != 'default') {
    $class = $settings['button_style'] != 'iq-btn-link' ? 'btn-hover' : '';

    $this->add_render_attribute('iq_class', 'class', $class);
    $this->add_render_attribute('iq_class', 'class', esc_attr($settings['button_style']));
}

if (isset($settings['has_icon']) && $settings['has_icon'] == 'yes') {
    $this->add_render_attribute('iq_class', 'class', 'has-icon');
    $icon = sprintf('<i aria-hidden="true" class="%1$s"></i>', esc_attr($settings['button_icon']['value'], SE_TEXT_DOMAIN));

    if ($settings['icon_position'] == 'right') {
        $html .= $icon;
        $this->add_render_attribute('iq_class', 'class', 'btn-icon-right');
    }

    if ($settings['icon_position'] == 'left') {
        $html = $icon . $html;
        $this->add_render_attribute('iq_class', 'class', 'btn-icon-left');
    }
}

if ($button_action == 'link' && $settings['link']['url']) {
    $link_url = $settings['link']['url'];
    $this->add_render_attribute('iq_class', 'href', esc_url($link_url));
}

if ($button_action == 'movie_tv' && !empty($settings['iq_movie_tv_id'])) {
    $movie_tv_url = get_the_permalink((int) $settings['iq_movie_tv_id']);
    $this->add_render_attribute('iq_class', 'href', esc_url($movie_tv_url));
}

if ($button_action == 'page' && !empty($settings['iq_page_id'])) {
    $page_url = get_the_permalink((int) $settings['iq_page_id']);
    $this->add_render_attribute('iq_class', 'href', esc_url($page_url));
}

if ($button_action == 'product' && !empty($settings['iq_product_id'])) {
    $product_url = get_the_permalink((int) $settings['iq_product_id']);
    $this->add_render_attribute('iq_class', 'href', esc_url($product_url));
}

if ($button_action == 'product_cat' && !empty($settings['iq_product_cat_id'])) {
    $product_cat_url =  get_term_link($settings['iq_product_cat_id'], 'product_cat');
    $this->add_render_attribute('iq_class', 'href', esc_url($product_cat_url));
}

if ($button_action == 'popup') {
    $modalid = 'mymodal' . rand(10, 1000);

    $this->add_render_attribute('iq_class', 'data-toggle', 'modal');
    $this->add_render_attribute('iq_class', 'data-target', '#' . $modalid);
    $this->add_render_attribute('iq_class', 'href', '#' . $modalid);
}

if (isset($settings['link']['is_external']) && $settings['link']['is_external']) {
    $this->add_render_attribute('iq_class', 'target', '_blank');
}

if (isset($settings['link']['nofollow']) && $settings['link']['nofollow']) {
    $this->add_render_attribute('iq_class', 'rel', 'nofollow');
} ?>

<div class="<?php echo esc_attr__("iq-btn-container", SE_TEXT_DOMAIN) ?>">
    <a <?php echo $this->get_render_attribute_string('iq_class') ?>>
        <span>
            <?php echo $html; ?>
        </span>
    </a>
</div>

<?php if ($button_action == 'popup') { ?>
    <div class="iq-modal">
        <div class="modal fade" id="<?php echo esc_attr($modalid); ?>" tabindex="-1" role="dialog" aria-labelledby="exampleModalCenterTitle" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-lg" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalCenterTitle"><?php echo $settings['model_title'] ?></h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true"><?php Icons_Manager::render_icon($settings['model_selected_icon'], ['aria-hidden' => 'true']); ?></span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <?php echo $this->parse_text_editor($settings['model_body']); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>