<?php

namespace Iqonic\Elementor\Elements\Button;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iq_button';
	}

	public function get_title()
	{
		return esc_html__('Iqonic Button', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-button';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_21eZ2eh1Myn3Vx5qrK29',
			[
				'label' => __('Button', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' => __('Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __('Read More', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'has_icon',
			[
				'label' => __('Use Icon?', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __('yes', 'streamit-extensions'),
				'no' => __('no', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'button_icon',
			[
				'label' => __('Icon', 'streamit-extensions'),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star'
				],
				'condition' => ['has_icon' => 'yes'],
			]
		);

		$this->add_responsive_control(
			'icon_position',
			[
				'label' => __('Icon Position', 'streamit-extensions'),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'right',
				'options' => [
					'left' => [
						'title' => __('Left', 'streamit-extensions'),
						'icon' => 'eicon-text-align-left',
					],
					'right' => [
						'title' => __('Right', 'streamit-extensions'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'condition' => ['has_icon' => 'yes'],
			]
		);

		$this->add_control(
			'button_action',
			[
				'label' => __('Action', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'none',
				'label_block' => true,
				'options' => [
					'movie_tv'  => __('Open Movie / Tv Show / Video', 'streamit-extensions'),
					'product'  => __('Product', 'streamit-extensions'),
					'product_cat'  => __('product Category', 'streamit-extensions'),
					'page'  => __('Pages', 'streamit-extensions'),
					'popup'  => __('Open Popup', 'streamit-extensions'),
					'link'  => __('Open Link', 'streamit-extensions'),
					'none'  => __('none', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'iq_movie_tv_id',
			[
				'label' => __('Select Movie / Tv Show / Video', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'multiple' => false,
				'label_block' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data(array('movie', 'tv_show', 'video'), false, true) : [],
				'condition' => ['button_action' => 'movie_tv']
			]
		);

		$this->add_control(
			'iq_product_id',
			[
				'label' => __('Select Product', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'multiple' => false,
				'label_block' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('product', false) : [],
				'condition' => ['button_action' => 'product']
			]
		);

		$this->add_control(
			'iq_product_cat_id',
			[
				'label' => __('Select Product category', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'multiple' => false,
				'label_block' => true,
				'options' => isset($_REQUEST['editor_post_id']) && function_exists('iqonic_get_taxonomies') ? iqonic_get_taxonomies('product_cat') : array(),
				'condition' => ['button_action' => 'product_cat']
			]
		);

		$this->add_control(
			'iq_page_id',
			[
				'label' => __('Select Pages', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'multiple' => false,
				'label_block' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data(array('page'), false, true) : [],
				'condition' => ['button_action' => 'page']
			]
		);

		$this->add_control(
			'link',
			[
				'label' => __('Link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __('https://your-link.com', 'streamit-extensions'),
				'default' => [
					'url' => '#',
				],
				'condition' => ['button_action' => 'link']
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_header',
			[
				'label' => __('Model Header', 'streamit-extensions'),
				'condition' => ['button_action' => 'popup']
			]
		);

		$this->add_control(
			'model_title',
			[
				'label' => __('Title', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __('Model Title', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'model_selected_icon',
			[
				'label' => __('Icon', 'streamit-extensions'),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star'
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_body',
			[
				'label' => __('Model Body', 'streamit-extensions'),
				'condition' => ['button_action' => 'popup']
			]
		);

		$this->add_control(
			'model_body',
			[
				'label' => __('Description', 'streamit-extensions'),
				'type' => Controls_Manager::WYSIWYG,
				'default' => __('Default description', 'streamit-extensions'),
				'placeholder' => __('Type your description here', 'streamit-extensions'),
			]
		);

		$this->end_controls_section();

		require 'style.php';
	}

	protected function render()
	{
		require 'render.php';
	}
}
