<?php

$postcat    = get_the_category($post_id);
$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "full");
$image_alt  = get_the_title(get_post_thumbnail_id($post_id)); ?>

<div class="<?php echo esc_attr($col) ?>">
    <div class="iq-blog-box">
        <div class="iq-blog-image clearfix">
            <img src="<?php echo esc_url($full_image[0]) ?>" alt="<?php $image_alt ?>">
        </div>

        <div class="iq-blog-detail">
            <div class="d-flex">
                <div class="iq-blog-meta">
                    <ul class="iq-postdate">
                        <li class="list-inline-item">
                            <?php echo sprintf("%s", iqonic_blog_time_link($post_id)); ?>
                        </li>
                    </ul>
                </div>

                <?php if ($postcat) { ?>
                    <ul class="iq-blogtag">
                        <?php foreach ($postcat as $cat) { ?>
                            <li>
                                <a href="<?php echo get_category_link($cat->cat_ID); ?>">
                                    <?php echo $cat->name; ?>
                                </a>
                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>
            </div>

            <div class="blog-title">
                <<?php echo esc_attr($title_tag); ?> class="mb-3">
                    <a href="<?php echo get_the_permalink($post_id); ?>">
                        <?php echo get_the_title($post_id); ?>
                    </a>
                </<?php echo esc_attr($title_tag); ?>>
            </div>

            <p> <?php echo get_the_excerpt($post_id); ?> </p>

            <div class="blog-button">
                <a class="iq-btn-link" href="<?php echo get_the_permalink($post_id); ?>">
                    <?php echo esc_html__('Read More', SE_TEXT_DOMAIN); ?>
                    <i class="fa fa-angle-right ml-2" aria-hidden="true"></i>
                </a>
            </div>
        </div>
    </div>
</div>