<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$cat = $blog_layout = $blog_art = $col = $temp_settings = '';

$rand 					= rand(10, 100);
$settings 				= $this->get_settings();
$title_tag  			= $settings['title_tag'];
$options_streamit_load 	= $settings['pagination'];
$loadmore_btn 			= 'blog-load-btn-' . $rand;
$paged 					= (get_query_var('paged')) ? get_query_var('paged') : 1;

$count 					= $settings['posts_per_page']['size'];
$is_grid				= $settings['blog_type'] == '2' ? true : false;

$args = array(
	'post_type'         => 'post',
	'posts_per_page' 	=> $count,
	'paged'				=> $paged,
	'post_status'       => 'publish',
	'order'           	=> $settings['order'],
	'suppress_filters'  => 0
);

$align = isset($settings['align']) && !empty($settings['align']) ? $settings['align'] : '';

if (isset($settings['blog_cat']) && !empty($settings['blog_cat'])) {
	$cat = implode(',', $settings['blog_cat']);
	$args['category_name'] = $cat;
}

$wp_query 				= new \WP_Query($args);
$max_page 				= $wp_query->max_num_pages;
$total_pages 			= $wp_query->max_num_pages;
$can_be_loaded 			= ($max_page > 1) ? true : false;

$current_page = max(1, get_query_var('paged')); ?>

<div class="iq-blog iq-ajax-content <?php echo esc_attr($align) ?> streamit_datapass_blog_grid" data-options="<?php echo esc_attr($options_streamit_load) ?>" data-can-beloaded="<?php echo esc_attr($can_be_loaded); ?>">
	<?php if ($settings['blog_type'] === '1') {
		$this->add_render_attribute('slider', 'data-dots', 				$settings['dots']);
		$this->add_render_attribute('slider', 'data-nav', 				$settings['nav-arrow']);
		$this->add_render_attribute('slider', 'data-items', 			$settings['desk_number']);
		$this->add_render_attribute('slider', 'data-items-laptop', 		$settings['lap_number']);
		$this->add_render_attribute('slider', 'data-items-tab', 		$settings['tab_number']);
		$this->add_render_attribute('slider', 'data-items-mobile', 		$settings['mob_number']);
		$this->add_render_attribute('slider', 'data-items-mobile-sm', 	$settings['mob_number']);
		$this->add_render_attribute('slider', 'data-autoplay', 			$settings['autoplay']);
		$this->add_render_attribute('slider', 'data-loop', 				$settings['loop']);
		$this->add_render_attribute('slider', 'data-margin', 			$settings['margin']['size']);
		$this->add_render_attribute('slider', 'data-padding', 			$settings['padding']['size']); ?>

		<div class="blog-carousel owl-carousel" <?php echo $this->get_render_attribute_string('slider') ?>>
			<?php if ($wp_query->have_posts()) {
				while ($wp_query->have_posts()) {
					$wp_query->the_post();
					$post_id = get_the_ID();

					require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
				}
			}
			wp_reset_postdata(); ?>
		</div>
	<?php } else {
		echo '<div class="blog_main_contens">';
		echo '<div class="row blog_grid_contens list-grid">';

		$blog_style = [
			"2" => 'col-lg-12 iqonic-space-bottom',
			"3" => 'col-lg-6 col-md-6 iqonic-space-bottom',
			"4" => 'col-lg-4 col-md-6 iqonic-space-bottom',
			"5" => 'col-lg-3 col-md-4 col-sm-6 iqonic-space-bottom'
		];

		$col = $blog_style[$settings['blog_style']];

		$temp_settings = [
			'col' 		=> $col,
			'title_tag'	=> $title_tag,
		];

		if ($wp_query->have_posts()) {
			while ($wp_query->have_posts()) {
				$wp_query->the_post();
				$post_id = get_the_ID();

				require trailingslashit(plugin_dir_path(__FILE__)) . 'template.php';
			}
		}
		wp_reset_postdata();
		echo '</div>';
		echo '</div>';
	} ?>

	<?php if ($is_grid && $can_be_loaded && $settings['pagination'] == 'yes') {
		streamit_get_numbers_pagination($total_pages);
	} elseif ($is_grid && $can_be_loaded && $settings['pagination'] == 'infinite' && $total_pages > 1) {
		echo '<div class="loader-wheel-container"></div>';
	} ?>
</div>

<?php if ($can_be_loaded) { ?>
	<div class="loader-wheel-container">
		<?php if ($is_grid && $settings['pagination'] == 'loadmore' && $total_pages > 1) : ?>
			<div class="<?php echo esc_attr($loadmore_btn); ?>">
				<div class="btn btn-hover iq-button">
					<span><?php echo !empty($settings['more_text']) ? esc_html($settings['more_text']) : '' ?></span>
				</div>
			</div>
		<?php endif;

		if ($is_grid && $settings['pagination'] == "yes") {
			$current_page  = max(1, get_query_var('paged')) - 1;
		}

		$pagination_args = [
			'action' 			=> 'loadmore_blog_grid',
			'current_page'		=> $current_page,
			'total_pages'		=> $total_pages,
			'loadmore_btn'		=> $loadmore_btn,
			'loading_text'		=> $settings['loading_text'],
			'query_args'		=> $args,
			'temp_settings'		=> $temp_settings,
			'posts_per_page' 	=> $count,
		];

		streamit_get_pagination_args($pagination_args); ?>
	</div>
<?php }
