<?php

namespace Iqonic\Elementor\Elements\Blog;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;
class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_blog';
	}

	public function get_title()
	{
		return esc_html__('Blog', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-posts-grid';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_blog',
			[
				'label' => __('Blog Post', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'blog_type',
			[
				'label'      => __('Blog Type', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => '1',
				'options'    => [
					'1'          => __('Blog Slider', 'streamit-extensions'),
					'2'          => __('Blog Grid', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'blog_style',
			[
				'label'      => __('Grid', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'condition' => [
					'blog_type' => '2',
				],
				'options'    => [
					'2'          => __('Blog 1 Columns', 'streamit-extensions'),
					'3'          => __('Blog 2 Columns', 'streamit-extensions'),
					'4'          => __('Blog 3 Columns', 'streamit-extensions'),
					'5'          => __('Blog 4 Columns', 'streamit-extensions'),
				],
				'default'    => '3',
			]
		);

		$this->add_control(
			'blog_cat',
			[
				'label' => esc_html__('Select blog category', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'return_value' => 'true',
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iqonic_by_blog_cat() : [],
			]
		);

		$this->add_control(
			'pagination',
			[
				'label'   => __('Show Pagintion/Loadmore/Infinite', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'loadmore',
				'label_block' => true,
				'options' => [
					'yes' 	   => esc_html__('Pagination', 'streamit-extensions'),
					'loadmore' => esc_html__('Loadmore', 'streamit-extensions'),
					'infinite' => esc_html__('Infinite Scroll', 'streamit-extensions')
				],
				'condition' => ['blog_type' => '2']
			]
		);

		$this->add_control(
			'more_text',
			[
				'label' => __('Load More button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Load More', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['blog_type' => '2', 'pagination' => 'loadmore']
			]
		);

		$this->add_control(
			'loading_text',
			[
				'label' => __('Loading button text', 'streamit-extensions'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Loading...', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['blog_type' => '2', 'pagination' => 'loadmore']
			]
		);

		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' => __('Posts Per Page', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => 10,
				],
			]
		);

		$this->add_control(
			'order',
			[
				'label'   => __('Order By', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ASC',
				'options' => [
					'DESC' => esc_html__('Descending', 'streamit-extensions'),
					'ASC' => esc_html__('Ascending', 'streamit-extensions')
				],
			]
		);

		$this->add_responsive_control(
			'align',
			[
				'label' => __('Alignment', 'streamit-extensions'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __('Left', 'streamit-extensions'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __('Center', 'streamit-extensions'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __('Right', 'streamit-extensions'),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => __('Justified', 'streamit-extensions'),
						'icon' => 'eicon-text-align-justify',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .iq-blog-box' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Title Tag', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'h4',
				'options'    => [
					'h1'          => __('h1', 'streamit-extensions'),
					'h2'          => __('h2', 'streamit-extensions'),
					'h3'          => __('h3', 'streamit-extensions'),
					'h4'          => __('h4', 'streamit-extensions'),
					'h5'          => __('h5', 'streamit-extensions'),
					'h6'          => __('h6', 'streamit-extensions'),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_slick_control',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'desk_number',
			[
				'label' => __('Desktop view', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'blog_type' => '1',
				],
				'label_block' => true,
				'default'    => '3',
				'classes' => "desk-ele-item",
			]
		);

		$this->add_control(
			'lap_number',
			[
				'label' => __('Laptop view', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'blog_type' => '1',
				],
				'label_block' => true,
				'default'    => '3',
				'classes' => "lap-ele-item",
			]
		);

		$this->add_control(
			'tab_number',
			[
				'label' => __('Tablet view', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'blog_type' => '1',
				],
				'label_block' => true,
				'default'    => '2',
				'classes' => "tab-ele-item",
			]
		);

		$this->add_control(
			'mob_number',
			[
				'label' => __('Mobile view', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'blog_type' => '1',
				],
				'label_block' => true,
				'default'    => '1',
				'classes' => "mob-ele-item",
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'      => __('Autoplay', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __('True', 'streamit-extensions'),
					'false'      => __('False', 'streamit-extensions'),
				],
				'condition' => [
					'blog_type' => '1',
				]
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label' => __('Autoplay Speed', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'label_block' => false,
				'condition' => [
					'blog_type' => '1', 'autoplay' => 'true'
				],
				'default' => '5000',
			]
		);

		$this->add_control(
			'loop',
			[
				'label'      => __('Loop', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __('True', 'streamit-extensions'),
					'false'      => __('False', 'streamit-extensions'),
				],
				'condition' => [
					'blog_type' => '1',
				]
			]
		);

		$this->add_control(
			'dots',
			[
				'label'      => __('Pagination', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __('True', 'streamit-extensions'),
					'false'      => __('False', 'streamit-extensions'),
				],
				'condition' => [
					'blog_type' => '1',
				]
			]
		);

		$this->add_control(
			'nav-arrow',
			[
				'label'      => __('Arrow', 'streamit-extensions'),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __('True', 'streamit-extensions'),
					'false'      => __('False', 'streamit-extensions'),
				],
				'condition' => [
					'blog_type' => '1',
				]
			]
		);

		$this->add_responsive_control(
			'margin',
			[
				'label' => __('Margin', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'condition' => [
					'blog_type' => '1',
				]
			]
		);

		$this->add_responsive_control(
			'padding',
			[
				'label' => __('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'condition' => [
					'blog_type' => '1',
				]
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callOwl();
					blogAjaxHandler();
				})(jQuery)
			</script>
<?php
		}
	}
}
