<?php

namespace Elementor;

use function Streamit\Utility\streamit;

if (!defined('ABSPATH')) exit;

global $streamit_options;

$slider 			= '';
$id_int 			= rand(10, 100);
$args = $post_names	= $tax_query = $taxargs = array();

$settings 	= $this->get_settings();

$repeater 	= $settings['tabs'];
$lazy_load	= $settings['enable_lazy_load_images'] == "yes" ? "iqonic-lazy-load-images" : "";

$this->add_render_attribute('slider', 'data-speed', 		 $settings['speed']);
$this->add_render_attribute('slider', 'data-autoplay', 		 $settings['autoplay']);
$this->add_render_attribute('slider', 'data-autoplay-speed', $settings['autoplay_speed']);

$args = array(
	'post_status' => 'publish',
	'fields' 	  => 'ids',
);

if ($settings['post_filter'] == "selected") {
	$args['post_type'] = array('tv_show', 'movie', 'video');

	foreach ($repeater as $index => $item) {
		$type = $item['iq_type'];
		if (!empty($item['iq_' . $type])) {
			$post_names[] = $item['iq_' . $type];
		}
	}
	$args['post_name__in'] 	= $post_names;
	$args['orderby'] 		= 'post_name__in';
} else {
	$post_types 			  = !empty($settings['filter_post_types']) ? $settings['filter_post_types'] : ['tv_show', 'movie', 'video'];
	$args['post_type'] 		  = $post_types;
	$args['posts_per_page']   = $settings['posts_per_page']['size'];
	$args['order']			  = "DESC";
	$args['orderby'] 		  = "date";
	$args['suppress_filters'] = true;
	$args['fields'] 		  = 'ids';

	if (isset($settings['iq_parent_movie_genre']) && !empty($settings['iq_parent_movie_genre'])) {
		$tax_query['operator'] 			= 'IN';
		$tax_query['field'] 			= 'slug';
		$tax_query['taxonomy'] 			= 'movie_genre';
		$tax_query['terms'] 			= $settings['iq_parent_movie_genre'];
		$tax_query['include_children'] 	= false;
		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_movie_genre'])) {
		$tax_query['operator'] 	= 'IN';
		$tax_query['field'] 	= 'slug';
		$tax_query['taxonomy'] 	= 'movie_genre';
		$tax_query['terms'] 	= $settings['iq_movie_genre'];
		$tax_query['include_children'] 	= true;

		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_movie_tag'])) {
		$tax_query['taxonomy'] 	= 'movie_tag';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_movie_tag'];
		$tax_query['operator'] 	= 'IN';
		array_push($taxargs, $tax_query);
	}

	if (isset($settings['iq_parent_tvshow_genre']) && !empty($settings['iq_parent_tvshow_genre'])) {
		$tax_query['operator'] 			= 'IN';
		$tax_query['field'] 			= 'slug';
		$tax_query['taxonomy'] 			= 'tv_show_genre';
		$tax_query['terms'] 			= $settings['iq_parent_tvshow_genre'];
		$tax_query['include_children'] 	= false;
		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_tvshow_genre'])) {
		$tax_query['taxonomy'] 	= 'tv_show_genre';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_tvshow_genre'];
		$tax_query['operator'] 	= 'IN';
		$tax_query['include_children'] 	= true;

		array_push($taxargs, $tax_query);
	}

	if (!empty($settings['iq_tvshow_tag'])) {
		$tax_query['taxonomy'] 	= 'tv_show_tag';
		$tax_query['field'] 	= 'slug';
		$tax_query['terms'] 	= $settings['iq_tvshow_tag'];
		$tax_query['operator'] 	= 'IN';
		array_push($taxargs, $tax_query);
	}

	if (!empty($taxargs)) {
		$args['tax_query'] 				= $taxargs;
		$args['tax_query']['relation'] 	= 'OR';
	}
}

$wp_query = new \WP_Query($args); ?>

<div id="home" class="iq-main-slider p-0 iq-rtl-direction iq-banner-thumb-slider inner-content <?php echo esc_attr($lazy_load) ?>">
	<div id="<?php echo esc_attr('home-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('home-slider-' . $id_int); ?>" class="home-slider slider m-0 p-0" <?php echo $this->get_render_attribute_string('slider'); ?>>
		<?php if ($wp_query->have_posts()) :
			$post_ids = $wp_query->posts; // Get an array of post IDs

			foreach ($post_ids as $post_id) {
				$run_time = $url_link = $censor_rating = $imdb_rating = $cast = $genre = $tag = $full_image = '';

				$post_type 	= get_post_type($post_id);
				$meta 		= get_post_meta($post_id);
				$url_link 	= get_the_permalink($post_id);
				$tags		= wp_get_post_terms($post_id, $post_type . '_tag');

				if ($post_type == "movie") {
					$movie_run_time = $meta['_movie_run_time'][0];
					$movie_url_link = $meta['_movie_url_link'][0];
					$censor_rating 	= $meta['_movie_censor_rating'][0];
					$movie_choice 	= $meta['_movie_choice'][0];
					$run_time 		= $meta['_movie_run_time'][0];
				} elseif ($post_type == "tv_show") {
					$censor_rating = streamit_get_seasons_count($meta);
					$run_time 	   = get_the_date('M Y');
					$season_data 	= unserialize($meta['_seasons'][0]);
				} else {
					$run_time 	= isset($meta['_video_run_time']) ? $meta['_video_run_time'][0] : '';
					$genres 	= wp_get_post_terms($post_id, $post_type . '_cat');
				}

				if ($post_type !== 'video') {
					$genres = wp_get_post_terms($post_id, $post_type . '_genre');
					$cast 	= streamit_get_casts($meta);
				}

				$genre = streamit_get_genres($genres);
				$tag   = streamit_get_tags($tags);

				$img_class = "img-fluid w-100";
				$srcset = '';

				if (has_post_thumbnail($post_id)) {
					$full_image = wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "full");
					$full_image = $full_image[0];

					if (!empty($lazy_load)) {
						$img_class .= ' iqonic-lazy';
						$lazy_image = get_lazy_load_image();

						$original_image = $full_image;
						$full_image 	= $lazy_image;
						$srcset 		= "data-srcset=" . $original_image . "";
					}
				} else {
					$full_image = get_lazy_load_image();
				} ?>

				<div class="slide slick-bg <?php echo esc_attr($post_type); ?> iqonic-lazy" style="background:url('<?php echo esc_attr($full_image) ?>')" <?php echo esc_attr($srcset); ?>>
					<div class="container-fluid position-relative h-100">
						<div class="slider-inner h-100">
							<div class="row align-items-center h-100">
								<div class="col-xl-7 col-lg-5 col-md-12">
									<div class="text-primary title tag RightAnimate">
										<span class="text-body d-flex align-items-center">
											<?php if (isset($censor_rating) && !empty($censor_rating)) { ?>
												<span class="font-normal badge px-3 py-2 mr-3 bg-white mr-3 <?php $post_type === 'video' && function_exists('set_post_view') ? esc_attr_e('video_view') : ''   ?>">
													<?php
													if ($post_type == 'tv_show') {
														if (is_array($season_data)) {
															printf('%d %s',count($season_data) , _n('Season','Seasons',count($season_data),SE_TEXT_DOMAIN) );
														} else
															esc_html_e('1 Season', SE_TEXT_DOMAIN);
													} else {
														echo esc_html($censor_rating);
													}
													?>
												</span>
											<?php }

											if (!empty($tag))
												echo $tag; ?>
										</span>
									</div>

									<h1 class="slider-text big-title title RightAnimate-two">
										<?php echo get_the_title($post_id); ?>
									</h1>

									<p class="RightAnimate-two">
										<?php $iq_excerpt = get_the_excerpt($post_id);
										if (!empty($iq_excerpt)) {
											$iq_remove_tags = array("<p>", "</p>");
											$iq_excerpt = str_replace($iq_remove_tags, "", $iq_excerpt);
											echo esc_html($iq_excerpt);
										} ?>
									</p>

									<div class="d-flex flex-wrap align-items-center horizontal-thumb-description RightAnimate-three">
										<?php streamit()->streamit_display_imdb_rating($post_id); ?>

										<div class="d-flex align-items-center slider-hours">
											<span class="font-normal">
												<?php echo esc_html($run_time); ?>
											</span>
										</div>

										<?php if (!empty($genre))
											echo $genre;

										if (!empty($cast))
											echo $cast; ?>
									</div>

									<div class="btn-radius RightAnimate-four">
										<a href="<?php echo get_the_permalink($post_id) ?>" class="btn btn-hover iq-button" tabindex="0">
											<?php echo sprintf(esc_html_x("%1s", "Verticle slider button for style one", SE_TEXT_DOMAIN), $settings['play_now_text']); ?>
											<i class="fa fa-play mr-2" aria-hidden="true"></i>
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

				<?php ob_start(); ?>
				<li>
					<div class="block-images position-relative <?php echo esc_attr($post_type); ?>">
						<img class="<?php echo esc_attr($img_class); ?>" src="<?php echo esc_url($full_image); ?>" <?php echo esc_attr($srcset); ?> alt="<?php echo esc_attr__('img', SE_TEXT_DOMAIN); ?>">

						<div class="block-description">
							<h6 class="iq-verticle-title"><?php echo get_the_title($post_id) ?></h6>
							<div class="movie-time d-flex align-items-center mt-1 ">
								<span class="movie-time-text font-normal">
									<?php echo esc_html($run_time); ?>
								</span>
							</div>
						</div>
					</div>
				</li>
		<?php $slider .= ob_get_clean();
			}
			wp_reset_postdata();
		endif;
		wp_reset_query(); ?>
	</div>

	<div class="horizontal_thumb_slider">
		<ul id="<?php echo esc_attr('banner-thumb-slider-nav-' . $id_int); ?>" data-rand="<?php echo esc_attr('banner-thumb-slider-nav-' . $id_int); ?>" class="banner-thumb-slider-nav list-inline p-0 m-0  d-flex align-items-center">
			<?php echo $slider; ?>
		</ul>
	</div>
</div>