<?php

namespace Iqonic\Elementor\Elements\Banner_Thumb_Slider;

use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Plugin;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'banner_thumb_slider';
	}

	public function get_title()
	{
		return esc_html__('Banner Thumb Slider', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-3d';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_thumb_slider',
			[
				'label' => __('Movie/TvShow/Video Thumb Slider', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'play_now_text',
			[
				'label' => __('Play Now Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Play Now', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label' => __('Lazy Load Images', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'post_filter',
			[
				'label' => __('Posts Filter', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => false,
				'options' => [
					'selected' 	=> __('Selected', 'streamit-extensions'),
					'latest' 	=> __('Latest', 'streamit-extensions')
				],
				'default' => 'selected'
			]
		);

		$this->add_control(
			'filter_post_types',
			[
				'label' => __('Posts Filter', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'movie' 	=> __('Movie', 'streamit-extensions'),
					'tv_show' 	=> __('Tv Show', 'streamit-extensions'),
					'video' 	=> __('Video', 'streamit-extensions')
				],
				'default' => ['movie', 'tv_show', 'video'],
				'condition' => ['post_filter' => 'latest']
			]
		);

		$this->add_responsive_control(
			'posts_per_page',
			[
				'label' => __('Posts Per Page', 'streamit-extensions'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
					'size' => 10,
				],
				'condition' => ['post_filter' => 'latest']
			]
		);

		do_action("lgbt_customization_fields_movie", $this);

		$this->add_control(
			'iq_movie_genre',
			[
				'label' 		=> __('Display Movie From Specific Genre', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT2,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('movie_genre') : [],
				'condition' => ['post_filter' => 'latest']
			]
		);

		$this->add_control(
			'iq_movie_tag',
			[
				'label' 		=> __('Display Movie From Specific Tags', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('movie_tag') : [],
				'condition' 	=> ['post_filter' => 'latest']
			]
		);

		do_action("lgbt_customization_fields_tvshow", $this);

		$this->add_control(
			'iq_tvshow_genre',
			[
				'label' 		=> __('Display Tv Show From Specific Genre', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT2,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('tv_show_genre') : [],
				'condition' 	=> ['post_filter' => 'latest']
			]
		);

		$this->add_control(
			'iq_tvshow_tag',
			[
				'label' 		=> __('Display Tv Show From Specific Tags', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT2,
				'label_block'	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_get_custom_taxonomy('tv_show_tag') : [],
				'condition' 	=> ['post_filter' => 'latest']
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'iq_type',
			[
				'label' 		=> __('Post Type', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'default' 		=> 'movie',
				'options' 		=> [
					'movie' 	=> __('Movie', 'streamit-extensions'),
					'tv_show' 	=> __('Tv Show', 'streamit-extensions'),
					'video' 	=> __('Video', 'streamit-extensions')
				],
			]
		);

		$repeater->add_control(
			'iq_tv_show',
			[
				'label' 		=> __('Display Specific Tv-Show', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('tv_show', true) : [],
				'condition' 	=> ['iq_type' => ['tv_show']],
			]
		);

		$repeater->add_control(
			'iq_movie',
			[
				'label' 		=> __('Display Specific Movie', 'streamit-extensions'),
				'type' 			=> Controls_Manager::SELECT,
				'label_block' 	=> true,
				'multiple' 		=> true,
				'options' 		=> isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('movie', true) : [],
				'condition' 	=> ['iq_type' => ['movie']],
			]
		);

		$repeater->add_control(
			'iq_video',
			[
				'label' => __('Display Specific Video', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('video', true) : [],
				'condition' => ['iq_type' => ['video']],
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' 	=> __('Select Posts To Display', 'streamit-extensions'),
				'type' 		=> Controls_Manager::REPEATER,
				'fields' 	=> $repeater->get_controls(),
				'condition' => ['post_filter' => 'selected']
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_slick_control',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label' => __('Autoplay', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label' => __('Autoplay Speed', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'label_block' => false,
				'condition' => ['autoplay' => 'true'],
				'default' => '5000',
			]
		);

		$this->add_control(
			'speed',
			[
				'label' => __('Speed', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'label_block' => false,
				'default' => '500',
			]
		);

		$this->add_control(
			'arrow_back_normal_color',
			[
				'label' => __('Arrow Hover Background Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slick-arrow:hover' => 'background: {{VALUE}}; border: 0.0625em solid {{VALUE}};'
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __('Icon Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slick-arrow i' => 'color: {{VALUE}};--iq-primary:{{VALUE}}; --active:{{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_banner_style',
			[
				'label' => __('Main', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'main_padding',
			[
				'label' => __('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slider-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'main_margin',
			[
				'label' => __('Margin', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slider-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ;',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_button_style',
			[
				'label' => __('Button', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label' => __('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .btn-radius .iq-button.btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'button_border_radius',
			[
				'label' => __('Border Radius', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .btn-radius .iq-button.btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';

		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callBannerThumbSlider(jQuery('.iq-banner-thumb-slider .home-slider').not('.slick-initialized'),jQuery);
				})(jQuery);
			</script>
<?php
		}
	}
}
