<?php

namespace Elementor;

use function Streamit\Utility\streamit;

if (!defined('ABSPATH')) exit;

global $streamit_options;

$id_int = rand(10, 100);
$args 	= $tax_query = array();

$settings 		= $this->get_settings_for_display();
$tabs 			= $settings['tabs'];
$display_cast 	= $settings['view_all_starring'] == "block" ? true : false;
$display_genres = $settings['view_all_genres'] 	 == "block" ? true : false;
$display_tag    = $settings['view_all_tag'] 	 == "block" ? true : false;
$display_logo   = $settings['view_logo'] 		 == "block" ? true : false;
$lazy_load		= $settings['enable_lazy_load_images'] == "yes" ? "iqonic-lazy-load-images" : "";

$this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
$this->add_render_attribute('slider', 'data-infinite', $settings['infinite']);
$this->add_render_attribute('slider', 'data-speed', $settings['speed']);
$this->add_render_attribute('slider', 'data-autoplay-speed', $settings['autoplay_speed']); ?>

<div id="home" class="iq-main-slider p-0 iq-rtl-direction iq-home-banner-slider <?php echo esc_attr($lazy_load) ?>">
	<div id="<?php echo esc_attr('home-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('home-slider-' . $id_int); ?>" class="home-slider slider m-0 p-0" <?php echo $this->get_render_attribute_string('slider'); ?>>
		<?php foreach ($tabs as $index => $item) {
			$args = array(
				'post_type'         => array('tv_show', 'movie', 'video'),
				'post_status'       => 'publish',
				'posts_per_page' 	=> -1,
				'fields'			=> 'ids'
			);

			$type = $item['iq_type'];
			if (!empty($item['iq_' . $type])) {
				$args['name'] = $item['iq_' . $type];
			}

			if (!isset($args['name'])) return;

			$view_class = $item['iq_type'] === 'video' && function_exists('set_post_view') ? 'video_view' : '';

			$wp_query = new \WP_Query($args);
			$post_ids = $wp_query->posts;

			if ($wp_query->have_posts()) :
				foreach ($post_ids as $post_id) {
					$run_time = $censor_rating = $imdb_rating = $cast = $genres = $tags = $genre = $tag = '';

					$post_type 		= get_post_type($post_id);
					$meta 			= get_post_meta($post_id);
					$url_link		= get_the_permalink($post_id);
					$trailer_link 	= $meta['name_trailer_link'][0];
					$tags   		= wp_get_post_terms($post_id, $item['iq_type'] . '_tag');
					$movie_logo 	= wp_get_attachment_image_src($meta['name_logo'][0], "full");
					$full_image 	= wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "full");

					if ($item['iq_type'] === 'movie') {
						$censor_rating 	= $meta['_movie_censor_rating'][0];
					}

					if ($item['iq_type'] !== "tv_show") {
						$run_time 	= $meta['_' . $item['iq_type'] . '_run_time'][0];
					} else {
						$season_data = unserialize($meta['_seasons'][0]);
						if (is_array($season_data)) {
							$season_count = count($season_data);
							$censor_rating = $season_count . _n(" Season", " Seasons", $season_count, SE_TEXT_DOMAIN);
						} else {
							$censor_rating = esc_html__("Arriving soon", SE_TEXT_DOMAIN);
						}
					}

					if ($item['iq_type'] !== 'video') {
						$casts 	= $meta['_cast'][0];
						$genres = wp_get_post_terms($post_id, $item['iq_type'] . '_genre');

						if (!empty($casts) && is_array($casts)) {
							foreach ($casts as $data) {
								$cast_obj = get_post($data['id']);
								if (get_post_type($cast_obj) != 'person') continue;
								$cast .= '<a href="' . get_the_permalink($cast_obj) . '"><span class="text-body">' . $cast_obj->post_title . '</span></a>' . ", ";
							}
							$cast = rtrim($cast, ", ");
						}

						if (!empty($genres)) {
							foreach ($genres as $val) {
								$genre .= '<a href="' . get_term_link($val->term_id) . '"><span class="text-body">' . $val->name . '</span></a>' . ', ';
							}
							$genre = rtrim($genre, ", ");
						}
					} else {
						$genres = wp_get_post_terms($post_id, $item['iq_type'] . '_cat');
					}

					if (!empty($tags)) {
						foreach ($tags as $val) {
							$tag .= '<a href="' . get_term_link($val->term_id) . '"><span class="text-body">' . $val->name . '</span></a>' . ', ';
						}
						$tag = rtrim($tag, ", ");
					}

					if (!empty($item['slider_image']['url']))
						$slider_image = $item['slider_image']['url'];
					else if (has_post_thumbnail($post_id))
						$slider_image = $full_image[0];
					else
						$slider_image = '';

					if (!empty($lazy_load) && !empty($slider_image)) {
						$img_class 	= ' iqonic-lazy';
						$lazy_image = get_lazy_load_image();

						$original_image = $slider_image;
						$slider_image 	= $lazy_image;
						$srcset 		= "data-srcset=" . $original_image . "";
					} else {
						$img_class = '';
						$srcset = '';
					} ?>

					<!-- Slide with Vimeo Background -->
					<div class="slide slick-bg <?php echo esc_attr($post_type); ?> <?php echo esc_attr($img_class); ?>" >
						<div class="video-background">
							<?php 
							$vimeo_link = $item['vimeo_link']['url'];
							$start_time = isset($item['start_time']) ? $item['start_time'] : 0;

							// Extract Vimeo video ID from URL
							preg_match('/vimeo\.com\/(\d+)/', $vimeo_link, $matches);
							$vimeo_id = isset($matches[1]) ? $matches[1] : '';

							if ($vimeo_id) : ?>
								<iframe class="appod" src="https://player.vimeo.com/video/<?php echo esc_attr($vimeo_id); ?>?autoplay=1&background=1&start=<?php echo esc_attr($start_time); ?>" width="640" height="360" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen style="position: absolute; top: 0; left: 0; width: 100%; z-index: -1; opacity: 0.5;"></iframe>
							<?php endif; ?>
						</div>
						<div class="container-fluid position-relative h-100">
							<div class="slider-inner h-100">
								<div class="row align-items-center  h-100">
									<div class="col-lg-7 col-md-12">
										<?php if ($display_logo && isset($movie_logo[0])) :
											if (!empty($movie_logo['alt']))
												$alt = $movie_logo['alt'];
											else
												$alt = esc_attr__('image', SE_TEXT_DOMAIN); ?>

											<a href="javascript:void(0);">
												<div class="channel-logo RightAnimate">
													<img src="<?php echo esc_url($movie_logo[0]); ?>" class="c-logo" alt="<?php echo esc_attr($alt); ?>">
												</div>
											</a>
										<?php endif; ?>

										<h1 class="slider-text big-title title text-uppercase RightAnimate-two">
											<?php echo get_the_title($post_id); ?>
										</h1>

										<div class="d-flex flex-wrap align-items-center RightAnimate-two <?php echo esc_attr($post_type) . "-meta"; ?>">
											<?php streamit()->streamit_display_imdb_rating($post_id); ?>

											<div class="d-flex align-items-center">
												<span class="font-normal badge badge-secondary p-2 <?php echo esc_attr($view_class); ?>">
													<?php
													if ($item['iq_type'] === 'video' && function_exists('set_post_view')) {
														echo '<i class="fa fa-eye"></i>';
														echo get_post_view($post_id);
													} else {
														echo esc_html($censor_rating);
													} ?>
												</span>

												<span class="font-normal ml-3">
													<?php if ($item['iq_type'] === 'tv_show')
														echo get_the_date('M Y', $post_id);
													else
														echo esc_html($run_time); ?>
												</span>
											</div>
										</div>

										<p class="RightAnimate-three">
											<?php
											$iq_excerpt = get_the_excerpt($post_id);
											if (!empty($iq_excerpt)) {
												$iq_remove_tags = array("<p>", "</p>");
												$iq_excerpt = str_replace($iq_remove_tags, "", $iq_excerpt);
												echo esc_html($iq_excerpt);
											} ?>
										</p>

										<div class="trending-list RightAnimate-three">
											<?php if ($display_cast && $item['iq_type'] !== 'video' && !empty($cast)) : ?>
												<div class="text-primary title starring">
													<?php echo esc_html($streamit_options['streamit_starring_title']); ?>
													<span class="text-body">
														<?php echo $cast; ?>
													</span>
												</div>
											<?php endif; ?>

											<?php if ($display_genres && $item['iq_type'] !== 'video' && !empty($genre)) : ?>
												<div class="text-primary title genres">
													<?php echo esc_html($streamit_options['streamit_genres_title']); ?>
													<span class="text-body"><?php echo $genre; ?></span>
												</div>
											<?php endif; ?>

											<?php if ($display_tag && !empty($tag)) : ?>
												<div class="text-primary title tag">
													<?php echo esc_html($streamit_options['streamit_tag_title']); ?>
													<span class="text-body"><?php echo $tag; ?></span>
												</div>
											<?php endif; ?>
										</div>

										<?php if (isset($settings['show_view_all_btn']) && $settings['show_view_all_btn'] == 'yes') : ?>
											<div class="d-flex align-items-center r-mb-23 banner-view-btn RightAnimate-four">
												<a href="<?php echo esc_url($url_link) ?>" class="btn btn-hover iq-button"><i class="fa fa-play mr-2" aria-hidden="true"></i>
													<?php
													if (!empty($settings['play_now_text']))
														echo esc_html($settings['play_now_text']);
													else
														echo esc_html__('Play Now', SE_TEXT_DOMAIN);
													?>
												</a>
											</div>
										<?php endif; ?>
									</div>

									<?php if (!empty($trailer_link) && $settings['show_trailer_btn'] == 'block') : ?>
										<div class="col-lg-5 col-md-12 trailor-video iq-slider d-none d-lg-block">
											<a href="<?php echo esc_url($trailer_link); ?>" class="video-open playbtn">
												<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="80px" height="80px" viewBox="0 0 213.7 213.7" enable-background="new 0 0 213.7 213.7" xml:space="preserve">
													<polygon class='triangle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="73.5,62.5 148.5,105.8 73.5,149.1 " />
													<circle class='circle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" cx="106.8" cy="106.8" r="103.3" />
												</svg>
												<?php if (!empty($settings['trailer_text'])) { ?>
													<span class="w-trailor"><?php echo esc_html($settings['trailer_text']) ?></span>
												<?php }  ?>
											</a>
										</div>
									<?php endif; ?>
								</div>
							</div>
						</div>
					</div>
		<?php };
			endif;
			wp_reset_postdata();
		} ?>
	</div>
</div>