<?php

namespace Iqonic\Elementor\Elements\Banner_Slider;

use Elementor\Plugin;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'Iq_Movie_Banner_Slider';
	}

	public function get_title()
	{
		return esc_html__('Banner Slider', 'streamit-extensions');
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-slider-3d';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section_zhyghasgahs',
			[
				'label' => __('Movie/TvShow/Video Banner Slider', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'show_view_all_btn',
			[
				'label'   => __('Show Play Now Button', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'yes',
				'options' => [
					'yes' 	=> esc_html__('Yes', 'streamit-extensions'),
					'no' 	=> esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'play_now_text',
			[
				'label' => __('Play Now Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Play Now', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['show_view_all_btn' => ['yes']]
			]
		);

		$this->add_control(
			'show_trailer_btn',
			[
				'label'   => __('Show Trailer Button', 'streamit-extensions'),
				'type'    => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'trailer_text',
			[
				'label' => __('Trailer Text', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'default' => __('Watch Trailer', 'streamit-extensions'),
				'label_block' => true,
				'condition' => ['show_trailer_btn' => ['block']]
			]
		);

		$this->add_control(
			'enable_lazy_load_images',
			[
				'label' => __('Lazy Load Images', 'streamit-extensions'),
				'type' => Controls_Manager::SWITCHER,
				'yes' 			=> __('Yes', 'streamit-extensions'),
				'no' 			=> __('No', 'streamit-extensions'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);

		$this->add_control(
			'view_logo',
			[
				'label' => __('Show logo?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'show_view',
			[
				'label' => __('Show Views?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slider-inner .video_view' => 'display: {{value}};',
				],
			]
		);

		$this->add_control(
			'view_all_starring',
			[
				'label' => __('Show Starring?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'view_all_genres',
			[
				'label' => __('Show Genres?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$this->add_control(
			'view_all_tag',
			[
				'label' => __('Show Tags?', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'block',
				'options' => [
					'block' => esc_html__('Yes', 'streamit-extensions'),
					'none' => esc_html__('No', 'streamit-extensions')
				],
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'iq_type',
			[
				'label' => __('Select Specific Post', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => [
					'movie' 	=> __('Movie', 'streamit-extensions'),
					'tv_show' 	=> __('Tv Show', 'streamit-extensions'),
					'video' 	=> __('Video', 'streamit-extensions')
				],
				'default' => 'movie'
			]
		);

		$repeater->add_control(
			'iq_tv_show',
			[
				'label' => __('Display Specific Tv-Show', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('tv_show', true) : [],
				'condition' => ['iq_type' => ['tv_show']],
			]
		);

		$repeater->add_control(
			'iq_movie',
			[
				'label' => __('Display Specific Movie', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('movie', true) : [],
				'condition' => ['iq_type' => ['movie']],
			]
		);

		$repeater->add_control(
			'iq_video',
			[
				'label' => __('Display Specific Video', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'label_block' => true,
				'multiple' => true,
				'options' => isset($_REQUEST['editor_post_id']) ? iq_custom_post_data('video', true) : [],
				'condition' => ['iq_type' => ['video']],
			]
		);

		$repeater->add_control(
			'slider_image',
			[
				'label' => __('Slider  Image', 'streamit-extensions'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		// New Controls for Vimeo Video Background
		$repeater->add_control(
			'vimeo_link',
			[
				'label' => __('Vimeo Link', 'streamit-extensions'),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __('https://vimeo.com/123456789', 'streamit-extensions'),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'start_time',
			[
				'label' => __('Start Time (in seconds)', 'streamit-extensions'),
				'type' => Controls_Manager::NUMBER,
				'default' => 0,
				'label_block' => true,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => __('Item List', 'streamit-extensions'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_slick_control',
			[
				'label' => __('Slider Control', 'streamit-extensions'),
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label' => __('Autoplay', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'false',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label' => __('Autoplay Speed', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'label_block' => false,
				'condition' => ['autoplay' => 'true'],
				'default' => '5000',
			]
		);

		$this->add_control(
			'infinite',
			[
				'label' => __('Infinite', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'true',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'speed',
			[
				'label' => __('Speed', 'streamit-extensions'),
				'type' => Controls_Manager::TEXT,
				'label_block' => false,
				'default' => '500',
			]
		);

		$this->add_control(
			'nav-arrow',
			[
				'label' => __('Arrow', 'streamit-extensions'),
				'type' => Controls_Manager::SELECT,
				'default' => 'true',
				'options' => [
					'true' => __('True', 'streamit-extensions'),
					'false' => __('False', 'streamit-extensions'),
				],
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __('Icon Color', 'streamit-extensions'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slick-arrow ' => 'color: {{VALUE}};--iq-primary:{{VALUE}};--active:{{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_banner_style',
			[
				'label' => __('Main', 'streamit-extensions'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'main_padding',
			[
				'label' => __('Padding', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slider-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'main_margin',
			[
				'label' => __('Margin', 'streamit-extensions'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .iq-main-slider .slider-inner' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} ;',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		require 'render.php';
		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callBannerSlider(jQuery('.iq-home-banner-slider .home-slider'));
				})(jQuery);
			</script>
<?php
		}
	}
}