<?php

namespace Elementor;

use function Streamit\Utility\streamit;

if (!defined('ABSPATH')) exit;

global $streamit_options;

$id_int 	= rand(10, 100);
$settings 	= $this->get_settings();
$tabs 		= $settings['tabs'];
$lazy_load	= $settings['enable_lazy_load_images'] == "yes" ? "iqonic-lazy-load-images" : "";

$this->add_render_attribute('slider', 'data-nav', 			 $settings['nav-arrow']);
$this->add_render_attribute('slider', 'data-autoplay', 		 $settings['autoplay']);
$this->add_render_attribute('slider', 'data-autoplay-speed', $settings['autoplay_speed']);
$this->add_render_attribute('slider', 'data-infinite', 		 $settings['infinite']);
$this->add_render_attribute('slider', 'data-speed', 		 $settings['speed']); ?>

<div class="iq-main-slider p-0 iq-rtl-direction iq-tvshows-slider <?php echo esc_attr($lazy_load) ?>">
	<div id="<?php echo esc_attr('tvshows-slider-' . $id_int); ?>" data-rand="<?php echo esc_attr('tvshows-slider-' . $id_int); ?>" class="tvshows-slider" <?php echo $this->get_render_attribute_string('slider'); ?>>
		<?php foreach ($tabs as $index => $item) {
			$type = $item['iq_type'];

			$args = array(
				'post_type' 	=> $type,
				'post_status'   => 'publish',
				'fields'		=> 'ids'
			);

			if (!empty($item['iq_' . $type])) {
				$args['name'] = $item['iq_' . $type];
			}

			$wp_query = new \WP_Query($args);
			$post_ids = $wp_query->posts;

			if ($wp_query->have_posts()) :
				foreach ($post_ids as $post_id) {
					$run_time = $censor_rating = '';

					$meta 			= get_post_meta($post_id);
					$post_type 		= get_post_type($post_id);
					$url_link 		= get_the_permalink($post_id);
					$release_date 	= get_the_date('M Y', $post_id);
					$full_image 	= wp_get_attachment_image_src(get_post_thumbnail_id($post_id), "full");
					$trailer_link 	= isset($meta['name_trailer_link']) ? $meta['name_trailer_link'][0] : '';

					if ($post_type === "movie") {
						$run_time 		= $meta['_movie_run_time'][0];
						$censor_rating 	= $meta['_movie_censor_rating'][0];
					}

					if ($post_type === 'tv_show') {
						$season_data = unserialize($meta['_seasons'][0]);
						if (is_array($season_data)) {
							$season_count = count($season_data);
							$run_time = $season_count . _n(" Season", " Seasons", $season_count, SE_TEXT_DOMAIN);
						} else {
							$run_time = esc_html__("Arriving soon", SE_TEXT_DOMAIN);
						}
					}

					if ($type === 'video') {
						$video_run_time  = isset($meta['_video_run_time']) ? $meta['_video_run_time'][0] : '';
					}

					if (!empty($item['slider_image']['url']))
						$slider_image =  $item['slider_image']['url'];
					else if (has_post_thumbnail($post_id))
						$slider_image = $full_image[0];
					else
						$slider_image = "";

					if (!empty($lazy_load) && !empty($slider_image)) {
						$img_class = ' iqonic-lazy';
						$lazy_image = get_lazy_load_image();

						$original_image = $slider_image;
						$slider_image 	= $lazy_image;
						$srcset 		= "data-srcset=" . $original_image . "";
					} else {
						$srcset = $img_class = '';
					} ?>

					<div class="slick-bg <?php echo esc_attr($post_type); ?> <?php echo esc_attr($img_class); ?>" style="background:url(<?php echo esc_url($slider_image); ?>)" <?php echo esc_attr($srcset); ?>>
						<div class="shows-content h-100">
							<div class="row align-items-center h-100">
								<div class="col-lg-7 col-md-12">
									<h1 class="slider-text big-title title text-uppercase" data-animation-in="fadeInLeft" data-delay-in="0.1"><?php echo get_the_title($post_id); ?></h1>
									<?php
									//for videos, set post total views
									if ($type === 'video' && !empty($item['iq_video'])) { ?>
										<div class="d-flex align-items-center tv-movie-banner text-detail" data-animation-in="fadeInUp" data-delay-in="0.3">
											<span class="badge badge-secondary p-1 mr-2 video_view">
												<?php if (function_exists('set_post_view')) : ?>
													<i class="fa fa-eye"></i>
													<?php echo get_post_view($post_id); ?>
												<?php endif; ?>
											</span>
											<span class="span"><?php echo esc_html($video_run_time); ?></span>
											<span class="trending-year"><?php echo esc_html($release_date); ?></span>
										</div>
									<?php } else { ?>
										<?php streamit()->streamit_display_imdb_rating($post_id); ?>

										<div class="d-flex align-items-center tv-movie-banner text-detail" data-animation-in="fadeInUp" data-delay-in="0.3">
											<?php if (!empty($censor_rating)) { ?>
												<span class="badge badge-secondary p-2 mr-3 font-normal"><?php echo esc_html($censor_rating); ?></span>
											<?php } ?>

											<span class="font-normal"> <?php echo esc_html($run_time); ?> </span>
											<span class="trending-year font-normal"> <?php echo esc_html($release_date); ?> </span>
										</div>
									<?php } ?>

									<p data-animation-in="fadeInUp" data-delay-in="0.5" class="m-0">
										<?php $iq_excerpt = get_the_excerpt($post_id);

										$content = str_word_count($iq_excerpt);
										if (!empty($iq_excerpt)) {
											$iq_remove_tags = array("<p>", "</p>");
											$iq_excerpt = str_replace($iq_remove_tags, "", $iq_excerpt);
											echo esc_html($iq_excerpt);
										} ?>
									</p>

									<?php if (isset($settings['show_view_all_btn']) && $settings['show_view_all_btn'] == 'yes') { ?>
										<div class="d-flex align-items-center r-mb-23 banner-view-btn" data-animation-in="fadeInUp" data-delay-in="1.3">
											<a href="<?php echo esc_url($url_link); ?>" class="btn btn-hover iq-button">
												<i class="fa fa-play mr-2" aria-hidden="true"></i>
												<?php if (!empty($settings['play_now_text']))
													echo esc_html($settings['play_now_text']); ?>
											</a>
										</div>
									<?php } ?>
								</div>

								<?php if ($settings['show_trailer_btn'] === 'yes' && !empty($trailer_link)) { ?>
									<div class="col-lg-5 col-md-12 trailor-video iq-slider d-none d-lg-block">
										<a href="<?php echo esc_url($trailer_link); ?>" class="video-open playbtn">
											<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="80px" height="80px" viewBox="0 0 213.7 213.7" enable-background="new 0 0 213.7 213.7" xml:space="preserve">
												<polygon class='triangle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" points="73.5,62.5 148.5,105.8 73.5,149.1 " />
												<circle class='circle' fill="none" stroke-width="7" stroke-linecap="round" stroke-linejoin="round" stroke-miterlimit="10" cx="106.8" cy="106.8" r="103.3" />
											</svg>

											<?php if (!empty($settings['trailer_text'])) { ?>
												<span class="w-trailor">
													<?php echo esc_html($settings['trailer_text']) ?>
												</span>
											<?php } ?>
										</a>
									</div>
								<?php } ?>
							</div>
						</div>
					</div>
		<?php
				}
			endif;
			wp_reset_postdata();
		} ?>
	</div>
</div>