<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$style = $settings['search_style'];

if ($style == 'style-2') :
    $this->add_render_attribute('inner-wrap', 'class', "iq-form-fields");
    $this->add_render_attribute('main-wrap', 'class', "iq-ajax-search iq-ajax-search-2");
else :
    $wrapper_start = '';
    $wrapper_end = '';
    $this->add_render_attribute('main-wrap', 'class', "iq-ajax-search");
endif; ?>

<div <?php echo $this->get_render_attribute_string('main-wrap'); ?>>
    <a href="javascript:void(0);" class="search-toggle device-search active">
        <?php \Elementor\Icons_Manager::render_icon($settings['search_icon'], ['aria-hidden' => 'true']); ?>
    </a>

    <div class="search-box iq-search-bar d-search active">
        <form method="get" class="search-form search__form" action="<?php echo esc_url(home_url()) ?>" autocomplete="off">
            <div <?php echo $this->get_render_attribute_string('inner-wrap'); ?>>
                <input type="search" id="searchInput" class="search-field search__input" placeholder="<?php echo esc_attr__('Search', SE_TEXT_DOMAIN) ?>" value="" name="s" data-search-style="<?php echo esc_attr($style); ?>">
                <input type="hidden" name="ajax_search" value="true">
                <button type="submit" class="search-submit">
                    <i class="fa fa-search" aria-hidden="true"></i>
                    <span class="screen-reader-text"><?php echo esc_html__('Search', SE_TEXT_DOMAIN) ?></span>
                </button>
            </div>
            <div class="search_result_history"></div>
            <div class="datafetch"></div>
        </form>
    </div>
</div>