<?php

namespace Iqonic\Elementor\Elements\Ajax_Search;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_ajax_search';
    }

    public function get_title()
    {
        return __('Layouts: Ajax Search', 'streamit-extensions');
    }

    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-search';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_iqonic_layouts_search',
            [
                'label' => __('Layouts: Ajax Search', 'streamit-extensions'),
            ]
        );

        $this->add_control(
            'search_style',
            [
                'label' => __('Select Style', 'streamit-extensions'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style-1' => __('Style 1', 'streamit-extensions'),
                    'style-2' => __('Style 2', 'streamit-extensions'),
                ],
                'default' => 'style-1',
            ]
        );

        $this->add_control(
            'show_search_icon',
            [
                'label' => __('Show Search Icon', 'streamit-extensions'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __('Show', 'streamit-extensions'),
                'label_off' => __('Hide', 'streamit-extensions'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'search_icon',
            [
                'label' => __('Icon', 'text-domain'),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-search',
                    'library' => 'solid',
                ],
                'condition' => [
                    'show_search_icon' => 'yes'
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';
    }
}
