<?php

use Elementor\Controls_Manager;

$this->start_controls_section(
    'section_title_style',
    [
        'label' => __('Title', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'title_color',
    [
        'label' => __('Text Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-title .accordion-title' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'title_active_color',
    [
        'label' => __('Text Active Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-active .iq-accordion-title .accordion-title' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'title_back_color',
    [
        'label' => __('Background Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-title' => 'background: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'title_back_active_color',
    [
        'label' => __('Active Background Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-active .iq-accordion-title' => 'background: {{VALUE}};',
        ],
    ]
);
$this->end_controls_section();

$this->start_controls_section(
    'section_content_style',
    [
        'label' => __('Content', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'content_color',
    [
        'label' => __('Content Text Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-details' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'content_back_color',
    [
        'label' => __('Background Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-details' => 'background: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_icon_style',
    [
        'label' => __('Icon', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'icon_active_color',
    [
        'label' => __('Active Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-block.iq-active .iq-accordion-title i.active' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'icon_inactive_color',
    [
        'label' => __('Inactive Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-block .iq-accordion-title i.inactive' => 'color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_section();

$this->start_controls_section(
    'section_border_style',
    [
        'label' => __('Border', SE_TEXT_DOMAIN),
        'tab' => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_control(
    'has_border',
    [
        'label' => __('Border?', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SWITCHER,
        'default' => 'label_off',
        'yes' => __('yes', SE_TEXT_DOMAIN),
        'no' => __('no', SE_TEXT_DOMAIN),
    ]
);

$this->add_control(
    'border_style',
    [
        'label' => __('Border Style', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SELECT,
        'default' => 'none',
        'options' => [
            'solid'  => __('Solid', SE_TEXT_DOMAIN),
            'dashed' => __('Dashed', SE_TEXT_DOMAIN),
            'dotted' => __('Dotted', SE_TEXT_DOMAIN),
            'double' => __('Double', SE_TEXT_DOMAIN),
            'outset' => __('outset', SE_TEXT_DOMAIN),
            'groove' => __('groove', SE_TEXT_DOMAIN),
            'ridge' => __('ridge', SE_TEXT_DOMAIN),
            'inset' => __('inset', SE_TEXT_DOMAIN),
            'hidden' => __('hidden', SE_TEXT_DOMAIN),
            'none' => __('none', SE_TEXT_DOMAIN),
        ],
        'condition' => [
            'has_border' => 'yes',
        ],
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-block' => 'border-style: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'border_active_color',
    [
        'label' => __('Active Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-block.iq-active' => 'border-color: {{VALUE}};',
        ],
        'condition' => [
            'has_border' => 'yes',
        ],
    ]
);

$this->add_control(
    'border_inactive_color',
    [
        'label' => __('Inactive Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-block' => 'border-color: {{VALUE}};',
        ],
        'condition' => [
            'has_border' => 'yes',
        ],
    ]
);

$this->add_control(
    'border_width',
    [
        'label' => __('Border Width', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::DIMENSIONS,
        'size_units' => ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .iq-accordion .iq-accordion-block' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
        'condition' => [
            'has_border' => 'yes',
        ],
    ]
);

$this->end_controls_section();
