<?php

namespace Iqonic\Elementor\Elements\Accordion;

use Elementor\Plugin;
use \Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
	public function get_name()
	{
		return 'iqonic_accordion';
	}

	public function get_title()
	{
		return esc_html__('Iqonic Accordion', SE_TEXT_DOMAIN);
	}

	public function get_categories()
	{
		return ['streamit-extension'];
	}

	public function get_icon()
	{
		return 'eicon-accordion';
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'section',
			[
				'label' => __('Accordion', SE_TEXT_DOMAIN),
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'tab_title',
			[
				'label' => __('Question', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::TEXT,
				'default' => __('What is Lorem Ipsum?', SE_TEXT_DOMAIN),
				'placeholder' => __('Tab Title', SE_TEXT_DOMAIN),
				'label_block' => true,
			]
		);

		$repeater->add_control(
			'tab_content',
			[
				'label' => __('Answer', SE_TEXT_DOMAIN),
				'default' => __('It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', SE_TEXT_DOMAIN),
				'placeholder' => __('Tab Content', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => false,
			]
		);

		$this->add_control(
			'tabs',
			[
				'label' => __('Tabs Items', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title' => __('Tab #1', SE_TEXT_DOMAIN),
						'tab_content' => __('Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.', SE_TEXT_DOMAIN),
					]
				],
				'title_field' => '{{{ tab_title }}}',
			]
		);

		$this->add_control(
			'has_icon',
			[
				'label' => __('Use Icon?', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __('yes', SE_TEXT_DOMAIN),
				'no' => __('no', SE_TEXT_DOMAIN),
			]
		);

		$this->add_control(
			'iqonic_has_box_shadow',
			[
				'label' => __('Box Shadow?', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __('yes', SE_TEXT_DOMAIN),
				'no' => __('no', SE_TEXT_DOMAIN),
			]
		);

		$this->add_control(
			'active_icon',
			[
				'label' => __('Active Icon', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star'

				],
				'condition' => [
					'has_icon' => 'yes',
				],
				'label_block' => false,
				'skin' => 'inline',
			]
		);

		$this->add_control(
			'inactive_icon',
			[
				'label' => __('Inactive Icon', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star'
				],
				'condition' => [
					'has_icon' => 'yes',
				],
				'label_block' => false,
				'skin' => 'inline',
			]
		);

		$this->add_responsive_control(
			'icon_position',
			[
				'label' => __('Icon Position', SE_TEXT_DOMAIN),
				'type' => Controls_Manager::CHOOSE,
				'default' => 'right',
				'options' => [
					'left' => [
						'title' => __('Left', SE_TEXT_DOMAIN),
						'icon' => 'eicon-text-align-left',
					],
					'right' => [
						'title' => __('Right', SE_TEXT_DOMAIN),
						'icon' => 'eicon-text-align-right',
					],
				],
				'condition' => [
					'has_icon' => 'yes',
				],
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'      => __('Title Tag', SE_TEXT_DOMAIN),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'h4',
				'options'    => [
					'h1'          => __('h1', SE_TEXT_DOMAIN),
					'h2'          => __('h2', SE_TEXT_DOMAIN),
					'h3'          => __('h3', SE_TEXT_DOMAIN),
					'h4'          => __('h4', SE_TEXT_DOMAIN),
					'h5'          => __('h5', SE_TEXT_DOMAIN),
					'h6'          => __('h6', SE_TEXT_DOMAIN),
				],
			]
		);

		$this->end_controls_section();

		require 'style.php';
	}

	protected function render()
	{
		require 'render.php';

		if (Plugin::$instance->editor->is_edit_mode()) { ?>
			<script>
				(function(jQuery) {
					callAccordion();
				})(jQuery);
			</script>
<?php
		}
	}
}
