<?php

namespace Elementor;

$this->add_control(
    'desk_number',
    [
        'label' => __('Desktop view', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],
        'label_block' => true,
        'default' => '5',
    ]
);

$this->add_control(
    'lap_extra_number',
    [
        'label' => __('Laptop Extra view', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],
        'label_block' => true,
        'default' => '6',
        'condition' => ['laptop_extra_view' => 'yes']
    ]
);

$this->add_control(
    'lap_number',
    [
        'label' => __('Laptop view', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],
        'label_block' => true,
        'default' => '4',
    ]
);

$this->add_control(
    'tab_number',
    [
        'label' => __('Tablet view', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],
        'label_block' => true,
        'default' => '3',
    ]
);

$this->add_control(
    'mob_number',
    [
        'label' => __('Mobile view', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
            'active' => true,
        ],
        'label_block' => true,
        'default' => '2',
    ]
);

$this->add_control(
    'autoplay',
    [
        'label' => __('Autoplay', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', SE_TEXT_DOMAIN),
            'false' => __('False', SE_TEXT_DOMAIN),
        ],
    ]
);

$this->add_control(
    'autoplay_speed',
    [
        'label' => __('Autoplay Speed', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::TEXT,
        'label_block' => false,
        'condition' => ['autoplay' => 'true'],
        'default' => '5000',
    ]
);

$this->add_control(
    'infinite',
    [
        'label' => __('Infinite', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', SE_TEXT_DOMAIN),
            'false' => __('False', SE_TEXT_DOMAIN),
        ],
    ]
);

$this->add_control(
    'speed',
    [
        'label' => __('Speed', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::TEXT,
        'label_block' => true,
        'default' => '300',
    ]
);

$this->add_control(
    'nav-arrow',
    [
        'label' => __('Arrow', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SELECT,
        'default' => 'true',
        'options' => [
            'true' => __('True', SE_TEXT_DOMAIN),
            'false' => __('False', SE_TEXT_DOMAIN),
        ],
    ]
);

$this->add_control(
    'nav-arrow-style',
    [
        'label' => __('Arrow Style', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::SELECT,
        'options' => [
            'style-1' => __('Style 1', SE_TEXT_DOMAIN),
            'style-2' => __('Style 2', SE_TEXT_DOMAIN),
        ],
        'default' => 'style-2',
        'condition' => ['nav-arrow' => 'true'],
    ]
);

$this->add_control(
    'arrow_back_normal_color',
    [
        'label' => __('Arrow Background Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .favorites-slider .slick-arrow i,{{WRAPPER}} .inner-slider .slick-arrow i,{{WRAPPER}} .trending-slider-nav .slick-arrow i,{{WRAPPER}} .trending-contens .slick-arrow i,{{WRAPPER}} .favorites-slider .slick-arrow svg,{{WRAPPER}} .inner-slider .slick-arrow svg,{{WRAPPER}} .trending-slider-nav .slick-arrow svg,{{WRAPPER}} .trending-contens .slick-arrow svg, {{WRAPPER}} .iq-woocommerce-product-slider .slick-arrow, {{WRAPPER}}.iq-main-slider .slick-arrow::before , {{WRAPPER}} .streamit-product-cat-slick .slick-arrow i, {{WRAPPER}} .streamit-product-cat-slick .slick-arrow svg,
            {{WRAPPER}} .favorites-slider .slick-arrow:hover, {{WRAPPER}} .streamit-continue-watching .PreArrow-two:hover, {{WRAPPER}} .streamit-continue-watching .NextArrow-two:hover'
            => 'background: {{VALUE}};',
        ],
        'condition' => ['nav-arrow' => 'true']
    ]
);

$this->add_control(
    'icon_color',
    [
        'label' => __('Icon Color', SE_TEXT_DOMAIN),
        'type' => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .favorites-slider .slick-arrow i,{{WRAPPER}} .inner-slider .slick-arrow i,{{WRAPPER}} .trending-slider-nav .slick-arrow i,{{WRAPPER}} .trending-contens .slick-arrow i,{{WRAPPER}} .favorites-slider .slick-arrow svg,{{WRAPPER}} .inner-slider .slick-arrow svg,{{WRAPPER}} .trending-slider-nav .slick-arrow svg,{{WRAPPER}} .iq-main-slider,{{WRAPPER}} .iq-woocommerce-product-slider .slick-arrow i, {{WRAPPER}} .streamit-product-cat-slick .slick-arrow i, {{WRAPPER}} .streamit-product-cat-slick .slick-arrow svg  ' => 'color: {{VALUE}};--iq-primary:{{VALUE}};--active:{{VALUE}}',
        ],
        'condition' => ['nav-arrow' => 'true']
    ]
);
