<?php

namespace Elementor;

$this->add_control(
	'post_view_type',
	[
		'label'   => __('Type', SE_TEXT_DOMAIN),
		'type'    => Controls_Manager::SELECT,
		'default' => 'none',
		'options' => [
			'none' 			=> esc_html__('None', SE_TEXT_DOMAIN),
			'latest' 		=> esc_html__('Latest', SE_TEXT_DOMAIN),
			'upcoming' 		=> esc_html__('Upcoming', SE_TEXT_DOMAIN),
			'most_viewed' 	=> esc_html__('Most Viewed', SE_TEXT_DOMAIN),
			'most_liked' 	=> esc_html__('Most Liked', SE_TEXT_DOMAIN),
			'alphabetic' 	=> esc_html__('Alphabetic', SE_TEXT_DOMAIN),
			'rand' 			=> esc_html__('Random', SE_TEXT_DOMAIN),
		],
	]
);

$this->add_control(
	'order',
	[
		'label'   => __('Order By', SE_TEXT_DOMAIN),
		'type'    => Controls_Manager::SELECT,
		'default' => 'ASC',
		'options' => [
			'DESC' 	=> esc_html__('Descending', SE_TEXT_DOMAIN),
			'ASC' 	=> esc_html__('Ascending', SE_TEXT_DOMAIN)
		],
		'condition' => ['post_view_type' => ['none', 'upcoming', 'alphabetic']],
	]
);
