<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$html = $icon = '';

$settings = $this->get_settings();
$bnt_link_tag = 'a';

$html .= esc_html($settings['button_text']);

$this->add_render_attribute('iq_container', 'class', 'iq-btn-container');
$this->add_render_attribute('iq_class', 'class', 'iq-button btn');

if ($settings['btn_has_box_shadow'] == 'yes') {
    $this->add_render_attribute('iq_class', 'class', 'iq-box-shadow');
}

if ($settings['button_size'] != 'default') {
    $this->add_render_attribute('iq_class', 'class', esc_attr($settings['button_size']));
}

if ($settings['button_style'] != 'default') {
    $this->add_render_attribute('iq_class', 'class', esc_attr($settings['button_style']));
}

if ($settings['has_icon'] == 'yes') {
    $this->add_render_attribute('iq_class', 'class', 'has-icon');
    $icon = sprintf('<i aria-hidden="true" class="%1$s"></i>', esc_attr($settings['button_icon']['value'], SE_TEXT_DOMAIN));

    if ($settings['icon_position'] == 'right') {
        $html .= $icon;
        $this->add_render_attribute('iq_class', 'class', 'btn-icon-right');
    }

    if ($settings['icon_position'] == 'left') {
        $html = $icon . $html;
        $this->add_render_attribute('iq_class', 'class', 'btn-icon-left');
    }
}

$this->add_render_attribute('iq_class', 'target', '_blank'); ?>

<div <?php echo $this->get_render_attribute_string('iq_container') ?>>
    <<?php echo $bnt_link_tag . ' ';
        echo $this->get_render_attribute_string('iq_class') ?>>
        <span>
            <?php echo $html; ?>
        </span>
    </<?php echo $bnt_link_tag; ?>>
</div>