<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$this->start_controls_section(
	'section_21eZ2eh1Myn3Vx5qrK29',
	[
		'label' => esc_html__('Button', 'streamit-extensions'),
	]
);

$this->add_control(
	'button_text',
	[
		'label' => esc_html__('Text', 'streamit-extensions'),
		'type' => Controls_Manager::TEXT,
		'dynamic' => [
			'active' => true,
		],
		'label_block' => true,
		'default' => esc_html__('Read More', 'streamit-extensions'),
	]
);

$this->add_control(
	'has_icon',
	[
		'label' => esc_html__('Use Icon?', 'streamit-extensions'),
		'type' => Controls_Manager::SWITCHER,
		'default' => 'no',
		'yes' => esc_html__('yes', 'streamit-extensions'),
		'no' => esc_html__('no', 'streamit-extensions'),
	]
);

$this->add_control(
	'button_icon',
	[
		'label' => esc_html__('Icon', 'streamit-extensions'),
		'type' => Controls_Manager::ICONS,
		'fa4compatibility' => 'icon',
		'default' => [
			'value' => 'fas fa-star'
		],
		'condition' => [
			'has_icon' => 'yes',
		],
	]
);


$this->add_responsive_control(
	'icon_position',
	[
		'label' => esc_html__('Icon Position', 'streamit-extensions'),
		'type' => Controls_Manager::CHOOSE,
		'default' => 'right',
		'options' => [
			'left' => [
				'title' => esc_html__('Left', 'streamit-extensions'),
				'icon' => 'eicon-text-align-left',
			],
			'right' => [
				'title' => esc_html__('Right', 'streamit-extensions'),
				'icon' => 'eicon-text-align-right',
			],
		],
		'condition' => [
			'has_icon' => 'yes',
		],
	]
);

$this->end_controls_section();

$this->start_controls_section(
	'section_uxf6ePJ1WkNzb9E5h72H',
	[
		'label' => esc_html__('Button Container', 'streamit-extensions'),
		'tab' => Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'btn_has_box_shadow',
	[
		'label' => esc_html__('Use Box Shadow?', 'streamit-extensions'),
		'type' => Controls_Manager::SWITCHER,
		'default' => 'no',
		'yes' => esc_html__('yes', 'streamit-extensions'),
		'no' => esc_html__('no', 'streamit-extensions'),
	]
);

$this->add_group_control(
	Group_Control_Box_Shadow::get_type(),
	[
		'name' => 'btn_box_shadow',
		'label' => esc_html__('Box Shadow', 'streamit-extensions'),
		'selector' => '{{WRAPPER}} .iq-button',
		'condition' => ['has_box_shadow' => 'yes']
	]
);

$this->add_responsive_control(
	'container_padding',
	[
		'label' => esc_html__('Padding', 'streamit-extensions'),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => ['px', '%'],
		'selectors' => [
			'{{WRAPPER}} .iq-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);

$this->add_responsive_control(
	'container_margin',
	[
		'label' => esc_html__('Margin', 'streamit-extensions'),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => ['px', '%'],
		'selectors' => [
			'{{WRAPPER}} .iq-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
	]
);

$this->add_responsive_control(
	'align_btn',
	[
		'label' => esc_html__('Alignment', 'streamit-extensions'),
		'type' => Controls_Manager::CHOOSE,
		'options' => [
			'left' => [
				'title' => esc_html__('Left', 'streamit-extensions'),
				'icon' => 'eicon-text-align-left',
			],
			'center' => [
				'title' => esc_html__('Center', 'streamit-extensions'),
				'icon' => 'eicon-text-align-center',
			],
			'right' => [
				'title' => esc_html__('Right', 'streamit-extensions'),
				'icon' => 'eicon-text-align-right',
			],
		],
		'selectors' => [
			'{{WRAPPER}} .iq-btn-container' => 'text-align: {{value}};',
		]
	]
);

$this->end_controls_section();

$this->start_controls_section(
	'section_d6iw352ACG3c5r1zvhYp',
	[
		'label' => esc_html__('Button Style', 'streamit-extensions'),
		'tab' => Controls_Manager::TAB_STYLE,
	]
);

$this->add_control(
	'button_size',
	[
		'label' => esc_html__('Size', 'streamit-extensions'),
		'type' => Controls_Manager::SELECT,
		'default' => 'default',
		'options' => [
			'iq-btn-small'  => esc_html__('Small', 'streamit-extensions'),
			'iq-btn-medium' => esc_html__('Medium', 'streamit-extensions'),
			'iq-btn-large' => esc_html__('Large', 'streamit-extensions'),
			'iq-btn-extra-large' => esc_html__('Extra Large', 'streamit-extensions'),
			'default' => esc_html__('Default', 'streamit-extensions'),
		],
	]
);

$this->add_control(
	'button_style',
	[
		'label' => esc_html__('Button Style', 'streamit-extensions'),
		'type' => Controls_Manager::SELECT,
		'default' => 'default',
		'options' => [
			'iq-btn-flat'  => esc_html__('Flat', 'streamit-extensions'),
			'iq-btn-outline' => esc_html__('Outline', 'streamit-extensions'),
			'iq-btn-link' => esc_html__('Link Button', 'streamit-extensions'),
			'default' => esc_html__('Default', 'streamit-extensions'),
		],
	]
);

$this->end_controls_section();
// Button style End

// Button Text Style
$this->start_controls_section(
	'section_d1da6dnvYM43C71weL29',
	[
		'label' => esc_html__('Button Text Color', 'streamit-extensions'),
		'tab' => Controls_Manager::TAB_STYLE,
	]
);

$this->start_controls_tabs('contact_tabs');
$this->start_controls_tab(
	'tabs_o8I22AKRc2bJa7BgdwHW',
	[
		'label' => esc_html__('Normal', 'streamit-extensions'),
	]
);

$this->add_control(
	'data_htext',
	[
		'label' => esc_html__('Choose Color', 'streamit-extensions'),
		'type' => Controls_Manager::COLOR,

		'selectors' => [
			'{{WRAPPER}} .iq-button' => 'color: {{VALUE}};',
		],
	]
);

$this->end_controls_tab();

$this->start_controls_tab(
	'tabs_1322c8M564ER8L6I65U0',
	[
		'label' => esc_html__('Hover', 'streamit-extensions'),
	]
);

$this->add_control(
	'data_hover_text',
	[
		'label' => esc_html__('Choose Hover Color', 'streamit-extensions'),
		'type' => Controls_Manager::COLOR,

		'selectors' => [
			'{{WRAPPER}} .iq-button:hover ,{{WRAPPER}} .streamit-product-box:hover  .iq-button' => 'color: {{VALUE}};',
		],
	]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_control(
	'color_devider',
	[
		'type' => Controls_Manager::DIVIDER,
	]
);

$this->add_group_control(
	Group_Control_Typography::get_type(),
	[
		'name' => 'btn_text_typography',
		'label' => esc_html__('Typography', 'streamit-extensions'),
		'selector' => '{{WRAPPER}} .iq-button',
	]
);

$this->end_controls_section();
// Button Text Style

// Background Style Start
$this->start_controls_section(
	'section_0s6Y4c68qoBcctzHf68f',
	[
		'label' => esc_html__('Button Background', 'streamit-extensions'),
		'tab' => Controls_Manager::TAB_STYLE,
	]
);

$this->start_controls_tabs('_dr6Yu5af63L5yHm3cGc1');
$this->start_controls_tab(
	'tabs_z5VRHMPjDcr6wJb0a4vF',
	[
		'label' => esc_html__('Normal', 'streamit-extensions'),
	]
);

$this->add_group_control(
	Group_Control_Background::get_type(),
	[
		'name' => 'data_background',
		'label' => esc_html__('Background', 'streamit-extensions'),
		'types' => ['classic', 'gradient', 'video'],
		'selector' => '{{WRAPPER}} .iq-button,{{WRAPPER}} .iq-button::before',
	]
);

$this->end_controls_tab();

$this->start_controls_tab(
	'tabs_Xa27O3BGf5k23KqHfeNM',
	[
		'label' => esc_html__('Hover', 'streamit-extensions'),
	]
);

$this->add_group_control(
	Group_Control_Background::get_type(),
	[
		'name' => 'data_hover',
		'label' => esc_html__('Background', 'streamit-extensions'),
		'types' => ['classic', 'gradient', 'video'],
		'selector' => '{{WRAPPER}} .iq-button:hover ,{{WRAPPER}} .streamit-product-box:hover .iq-button',
	]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->end_controls_section();

// Border Style Start
$this->start_controls_section(
	'section_iD8bVLQc8q83f4j5cnJk',
	[
		'label' => esc_html__('Button Border', 'streamit-extensions'),
		'tab' => Controls_Manager::TAB_STYLE,

	]
);

$this->add_control(
	'has_custom_border',
	[
		'label' => esc_html__('Use Custom Border?', 'streamit-extensions'),
		'type' => Controls_Manager::SWITCHER,
		'default' => 'no',
		'yes' => esc_html__('yes', 'streamit-extensions'),
		'no' => esc_html__('no', 'streamit-extensions'),
	]
);

$this->add_control(
	'data_border',
	[
		'label' => esc_html__('Border Color', 'streamit-extensions'),
		'type' => Controls_Manager::COLOR,
		'selectors' => [
			'{{WRAPPER}} .iq-button' => 'border-color: {{VALUE}};',
		],
		'condition' => ['has_custom_border' => 'yes'],
	]
);

$this->add_control(
	'data_hover_border_outline',
	[
		'label' => esc_html__('Hover Border Color', 'streamit-extensions'),
		'type' => Controls_Manager::COLOR,

		'selectors' => [
			'{{WRAPPER}} .iq-button:hover ,{{WRAPPER}} .streamit-product-box:hover  .iq-button' => 'border-color: {{VALUE}};',
		],
		'condition' => ['has_custom_border' => 'yes'],
	]
);

$this->add_control(
	'border_style',
	[
		'label' => esc_html__('Border Style', 'streamit-extensions'),
		'type' => Controls_Manager::SELECT,
		'default' => 'none',
		'options' => [
			'solid'  => esc_html__('Solid', 'streamit-extensions'),
			'dashed' => esc_html__('Dashed', 'streamit-extensions'),
			'dotted' => esc_html__('Dotted', 'streamit-extensions'),
			'double' => esc_html__('Double', 'streamit-extensions'),
			'outset' => esc_html__('outset', 'streamit-extensions'),
			'groove' => esc_html__('groove', 'streamit-extensions'),
			'ridge' => esc_html__('ridge', 'streamit-extensions'),
			'inset' => esc_html__('inset', 'streamit-extensions'),
			'hidden' => esc_html__('hidden', 'streamit-extensions'),
			'none' => esc_html__('none', 'streamit-extensions'),
		],
		'condition' => ['has_custom_border' => 'yes'],
		'selectors' => [
			'{{WRAPPER}} .iq-button' => 'border-style: {{VALUE}};',
		],
	]
);

$this->add_control(
	'border_width',
	[
		'label' => esc_html__('Border Width', 'streamit-extensions'),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => ['px', '%'],
		'selectors' => [
			'{{WRAPPER}} .iq-button' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
		'condition' => ['has_custom_border' => 'yes'],
	]
);

$this->add_control(
	'border_radius',
	[
		'label' => esc_html__('Border Radius', 'streamit-extensions'),
		'type' => Controls_Manager::DIMENSIONS,
		'size_units' => ['px', '%'],
		'selectors' => [
			'{{WRAPPER}} .iq-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		],
		'condition' => ['has_custom_border' => 'yes'],
	]
);

$this->end_controls_section();
// Border Style Start

// Icon Style Start
$this->start_controls_section(
	'section_qfCKlSw4To1FsPY6B33a',
	[
		'label' => esc_html__('Icon', 'streamit-extensions'),
		'tab' => Controls_Manager::TAB_STYLE,
		'condition' => ['has_icon' => 'yes']
	]
);

$this->add_control(
	'button_set_icon_size',
	[
		'label' => esc_html__('Set Icon Size?', 'streamit-extensions'),
		'type' => Controls_Manager::SWITCHER,
		'yes' => esc_html__('Yes', 'streamit-extensions'),
		'no' => esc_html__('no', 'streamit-extensions'),
		'return_value' => 'yes',
		'default' => 'no',
	]
);

$this->add_control(
	'button_icon_size',
	[
		'label' => esc_html__('Icon Size', 'streamit-extensions'),
		'type' => Controls_Manager::SLIDER,
		'size_units' => ['px', '%'],
		'range' => [
			'px' => [
				'min' => 0,
				'max' => 1000,
				'step' => 1,
			],
			'%' => [
				'min' => 0,
				'max' => 100,
				'step' => 1,
			],
		],
		'condition' => ['button_set_icon_size' => 'yes'],
		'selectors' => [
			'{{WRAPPER}} .iq-button i' => 'font-size: {{SIZE}}{{UNIT}};',
			'{{WRAPPER}} .iq-button svg' => 'height:{{SIZE}}{{UNIT}}; width:{{SIZE}}{{UNIT}};',
		],
	]
);

$this->add_control(
	'icon_spacing_left',
	[
		'label' => esc_html__('Icon Spacing', 'streamit-extensions'),
		'type' => Controls_Manager::SLIDER,
		'size_units' => ['px', '%'],
		'range' => [
			'px' => [
				'min' => 0,
				'max' => 1000,
				'step' => 1,
			],
			'%' => [
				'min' => 0,
				'max' => 100,
				'step' => 1,
			],
		],
		'condition' => ['icon_position' => 'left'],
		'selectors' => [
			'{{WRAPPER}} .iq-button.has-icon.btn-icon-left :is(i,svg)' => 'margin-right: {{SIZE}}{{UNIT}};'

		],
	]
);

$this->add_control(
	'icon_spacing_right',
	[
		'label' => esc_html__('Icon Spacing', 'streamit-extensions'),
		'type' => Controls_Manager::SLIDER,
		'size_units' => ['px', '%'],
		'range' => [
			'px' => [
				'min' => 0,
				'max' => 1000,
				'step' => 1,
			],
			'%' => [
				'min' => 0,
				'max' => 100,
				'step' => 1,
			],
		],
		'condition' => ['icon_position' => 'right'],
		'selectors' => [

			'{{WRAPPER}} .iq-button.has-icon.btn-icon-right :is(i,svg)' => 'margin-left: {{SIZE}}{{UNIT}};',
		],
	]
);

$this->end_controls_section();
