<?php

add_action('init', 'iqonic_pricing');

function iqonic_pricing()
{
	$url 	= get_template_directory_uri();
	$labels = array(
		'name'                  => esc_html__('Pricing Plan', SE_TEXT_DOMAIN),
		'singular_name'         => esc_html__('Pricing Plan', SE_TEXT_DOMAIN),
		'menu_name'             => esc_html__('Streamit Pricing', SE_TEXT_DOMAIN),
		'name_admin_bar'        => esc_html__('Streamit Pricing', SE_TEXT_DOMAIN),
		'add_new'               => esc_html__('Add New', SE_TEXT_DOMAIN),
		'add_new_item'          => esc_html__('Title', SE_TEXT_DOMAIN),
		'new_item'              => esc_html__('New Price', SE_TEXT_DOMAIN),
		'edit_item'             => esc_html__('Edit Price', SE_TEXT_DOMAIN),
		'view_item'             => esc_html__('View Pricing', SE_TEXT_DOMAIN),
		'all_items'             => esc_html__('All Pricing', SE_TEXT_DOMAIN),
		'search_items'          => esc_html__('Search Price', SE_TEXT_DOMAIN),
		'parent_item_colon'     => esc_html__('Parent Price :', SE_TEXT_DOMAIN),
		'not_found'             => esc_html__('No Classs found.', SE_TEXT_DOMAIN),
		'not_found_in_trash'    => esc_html__('No Classs found in Trash.', SE_TEXT_DOMAIN)
	);

	$args = array(
		'labels'             => $labels,
		'public'             => true,
		'publicly_queryable' => true,
		'show_ui'            => true,
		'show_in_menu'       => true,
		'query_var'          => true,
		'rewrite'            => true,
		'capability_type'    => 'post',
		'show_in_nav_menus'  => TRUE,
		'has_archive'        => true,
		'hierarchical'       => false,
		'menu_position'      => null,
		'menu_icon'          => $url . '/assets/images/redux/options.png',
		'supports'           => array('title')
	);

	register_post_type('pricing', $args);
}

add_action('after_setup_theme', 'iqonic_custom_taxonomy');
function iqonic_custom_taxonomy()
{
	register_taxonomy(
		'pricing_categories',
		'pricing',
		array(
			'label'         => esc_html__('Pricing Categories', SE_TEXT_DOMAIN),
			'rewrite'       => true,
			'hierarchical'  => true,
			'meta_box_cb' 	=> false,
		)
	);
}
