<?php

namespace Iqonic\Classes;

/**
 * Define the internationalization functionality.
 *
 * Loads and defines the internationalization files for this plugin
 * so that it is ready for translation.
 *
 * @since      1.1.0
 * @package    Streamit_Extension
 * @subpackage Streamit_Extension/includes
 * @link       https://iqonic.design/
 * @author     Iqonic Design <hello@iqonic.design>
 */

class Streamit_Extension_i18n
{
	/**
	 * Load the plugin text domain for translation.
	 *
	 * @since    1.1.0
	 */

	public function load_plugin_textdomain()
	{
		load_plugin_textdomain(
			'streamit-extensions',
			false,
			dirname(dirname(plugin_basename(__FILE__))) . '/languages/'
		);
	}
}
