<?php

namespace Iqonic\Classes;

use function Streamit\Utility\streamit;

/**
 * Fired during plugin activation
 *
 * @link       https://iqonic.design/
 * @since      1.1.0
 *
 * @package    Streamit_Extension
 * @subpackage Streamit_Extension/includes
 */

/**
 * Fired during plugin activation.
 *
 * This class defines all code necessary to run during the plugin's activation.
 *
 * @since      1.1.0
 * @package    Streamit_Extension
 * @subpackage Streamit_Extension/includes
 * @author     Iqonic Design <hello@iqonic.design>
 */
class Streamit_Extension_Activator
{

	/**
	 * Short Description. (use period)
	 *
	 * Long Description.
	 *
	 * @since    1.1.0
	 */

	public static function activate()
	{
		flush_rewrite_rules();

		//Creates Woocommerce Product For PMP, if woocommerce integration plugin is active
		if (function_exists("pmpro_getAllLevels") && function_exists("pmprowoo_init")) {
			$pmpro_plans = pmpro_getAllLevels(true);
			if ($pmpro_plans) {
				foreach ($pmpro_plans as $key => $value) {
					streamit()->streamit_add_woocommerce_product($value->id);
				}
			}
		}

		if (!class_exists('WP_Filesystem_Direct')) {
			require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-base.php';
			require_once ABSPATH . 'wp-admin/includes/class-wp-filesystem-direct.php';
		}

		$rm = new \WP_Filesystem_Direct([]);

		$upload_dir = wp_get_upload_dir()['basedir'];
		$css_dir    = $upload_dir . "/streamit/css/";
		$js_dir     = $upload_dir . "/streamit/js/";

		if (file_exists($js_dir))  $rm->delete($js_dir, true, 'd');
		if (file_exists($css_dir)) $rm->delete($css_dir, true, 'd');
	}
}
