<?php

namespace Iqonic\Classes;

use Iqonic\Acf;
use Iqonic\Elementor;
use Iqonic\Shortcodes;

class Streamit_Extension
{
    protected $loader;
    protected $version;
    protected $upload_dir;
    protected $plugin_name;
    protected $is_acf_active;

    public function __construct()
    {
        $this->plugin_name      = 'streamit-extension';
        $this->upload_dir       = wp_get_upload_dir();
        $this->loader           = new Streamit_Extension_Loader();
        $this->version          = defined('STREAMIT_EXTENSION_VERSION') ? STREAMIT_EXTENSION_VERSION : '1.0.0';
        $this->is_acf_active    = is_plugin_active('advanced-custom-fields/acf.php') || is_plugin_active('advanced-custom-fields-pro/acf.php');

        $this->set_locale();
        $this->load_shortcode();
        $this->define_redux_hooks();
        $this->register_shortcodes();
        $this->register_custom_post();
        $this->register_elementor_widgets(); //should be called before the function register_custom_helper => helpers.php

        $this->register_custom_helper();
        $this->define_elementor_hooks();

        if ($this->is_acf_active) $this->load_acf_dependencies();

        $this->loader->run();
    }

    public function set_locale()
    {
        $plugin_i18n = new Streamit_Extension_i18n();
        $this->loader->add_action('plugins_loaded', $plugin_i18n, 'load_plugin_textdomain');
    }

    public function load_shortcode()
    {
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/post-like/post-like.php';

        //user account
        if (!class_exists('Xoo_El_Core')) {
            require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/user-login.php';
        }
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/iq-view-all.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/user-profile.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/user-register.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/iq-view-count.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/user-playlist.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/user-watchlist.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/user-profile-edit.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/user-watchlist-view.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/User/user-forgot-password.php';
    }

    public function define_redux_hooks()
    {
        //Registers Redux Framework
        require_once "Redux_Panel.php";
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/ReduxCore/framework.php';

        //Registers Sidebar Widgets
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Widget/social_media.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Widget/recent-post.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Widget/working-days.php';
    }

    public function register_shortcodes()
    {
        new Shortcodes\Iqonic_Notification();
    }

    public function register_custom_post()
    {
        if (class_exists('Paid_Member_Subscriptions')) {
            // Registers Pricing CPT for PMS
            require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Custom_Post/Pricing.php';

            // Registers Pricing Plan Widget For PMS
            add_filter('streamit_register_cutom_widgets', [$this, 'streamit_register_pms_pricing_plan']);
        }

        if (function_exists('is_plugin_active') && is_plugin_active('paid-memberships-pro/paid-memberships-pro.php')) {
            // Registers Pricing Plan Widget For PMP
            add_filter('streamit_register_cutom_widgets', [$this, 'streamit_register_pmp_pricing_plan']);
        }

        if (is_plugin_active('woocommerce/woocommerce.php')) {
            add_filter('streamit_register_cutom_widgets', [$this, 'streamit_register_woo_widgets']);
        }
    }

    public function register_elementor_widgets()
    {
        $get_config_widgets         = $GLOBALS['iqonic_config'];
        $get_config_widgets         = apply_filters('streamit_register_cutom_widgets', $get_config_widgets);
        $GLOBALS['iqonic_config']   = $get_config_widgets;
    }

    public function register_custom_helper()
    {
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Utils/helpers.php';
        require_once STREAMIT_EXTENSION_PLUGIN_PATH . '/includes/Utils/ajax_helpers.php';
    }

    public function define_elementor_hooks()
    {
        $plugin_elementor = new Elementor\Streamit_Extension_Elementor($this->plugin_name, $this->version);

        $this->loader->add_action('elementor/init', $plugin_elementor, 'elementor_init');
        $this->loader->add_action('elementor/widgets/register', $plugin_elementor, 'include_widgets');

        $this->loader->add_action('wp_enqueue_scripts', $plugin_elementor, 'editor_enqueue_styles', 21);
        $this->loader->add_action('wp_enqueue_scripts', $plugin_elementor, 'editor_enqueue_scripts', 21);

        $this->loader->add_filter('elementor/frontend/builder_content_data', $plugin_elementor, 'load_used_items', 21, 2);

        //MAIN MINIFIED FUNCTION
        $this->loader->add_action("wp_enqueue_scripts", $plugin_elementor, 'iqonic_enqueue_dependent_scripts', 20);
    }

    public function load_acf_dependencies()
    {
        $phpSelf = basename($_SERVER['PHP_SELF']);

        switch ($phpSelf) {
            case 'post.php':
            case 'post-new.php':
                new Acf\General();
                new Acf\PortraitThumbnail();
                new Acf\Page();
                new Acf\Pricing();
                new Acf\Post();
                new Acf\Cast();
                break;
            case 'term.php':
            case 'edit-tags.php':
                new Acf\Meta();
                break;
            case 'profile.php':
            case 'user-edit.php':
                new Acf\Author();
                break;
        }
    }

    function streamit_register_pms_pricing_plan($config)
    {
        $existingElements = $config['Elements'];

        $newElements = [
            'iqonic_price' => [
                'class' => 'Iqonic\Elementor\Elements\Pricing_Plan\Widget',
                'dependency' => [
                    'js' => [
                        [
                            'name' => 'Pricing_Plan',
                            'src' => 'assets/js/Pricing_Plan.js',
                            'is_external'   => false
                        ]
                    ],
                    'css' => [
                        [
                            'name' => 'pricing-plan',
                            'src' => 'assets/css/pricing-plan.css',
                            'is_external'   => false

                        ]
                    ]
                ]
            ]
        ];

        $config['Elements'] = array_merge($existingElements, $newElements);
        return $config;
    }

    function streamit_register_pmp_pricing_plan($config)
    {
        $existingElements = $config['Elements'];

        $newElements = [
            'iq_pmp_pricing' => [
                'class' => 'Iqonic\Elementor\Elements\PMP_Pricing\Widget',
                'dependency' => [
                    'css' => [
                        [
                            'name'          => 'pmp-pricing',
                            'src'           => 'assets/css/pmp-pricing.css',
                            'is_external'   => false
                        ]
                    ],
                ]
            ],
        ];

        $config['Elements'] = array_merge($existingElements, $newElements);
        return $config;
    }

    function streamit_register_woo_widgets($config)
    {
        $existingElements = $config['Elements'];

        $newElements = [
            // WooCoomerce products
            'iqonic_products' => [
                'class' => 'Iqonic\Elementor\Elements\Products\Widget',
                'dependency' => [
                    'js' => [
                        [
                            'name'          => 'product-ajax',
                            'src'           => 'assets/js/product-ajax.js',
                            'is_external'   => false
                        ],
                    ],
                ],
            ],

            // WooCoomerce products Slider
            'iqonic_products_slider' => [
                'class' => 'Iqonic\Elementor\Elements\Products_Slider\Widget',
                'dependency' => [
                    'js' => [
                        [
                            'name'          => 'slick-min',
                            'src'           => 'assets/js/slick.min.js',
                            'is_external'   => true
                        ],
                        [
                            'name'          => 'slick-animation',
                            'src'           => 'assets/js/slick-animation.min.js',
                            'is_external'   => true
                        ],
                        [
                            'name'          => 'product-slider.js',
                            'src'           => 'assets/js/product-slider.js',
                            'is_external'   => false
                        ],
                    ],
                ],
            ],

            'iq_product_banner_slider' => [
                'class' => 'Iqonic\Elementor\Elements\Product_Banner_Slider\Widget',
                'dependency' => [
                    'js' => [
                        [
                            'name'          => 'slick-min',
                            'src'           => 'assets/js/slick.min.js',
                            'is_external'   => true
                        ],
                        [
                            'name'          => 'slick-animation',
                            'src'           => 'assets/js/slick-animation.min.js',
                            'is_external'   => true
                        ],
                        [
                            'name'          => 'Banner_Slider',
                            'src'           => 'assets/js/Banner_Slider.js',
                            'is_external'   => false
                        ],
                        [
                            'name'          => 'Product_Banner_Slider',
                            'src'           => 'assets/js/Product_Banner_Slider.js',
                            'is_external'   => false
                        ]
                    ],
                    'css' => [
                        [
                            'name'          => 'slick-theme',
                            'src'           => 'assets/css/slick-theme.css',
                            'is_external'   => false
                        ],
                        [
                            'name'          => 'slick-animation',
                            'src'           => 'assets/css/slick-animation.css',
                            'is_external'   => false
                        ],
                        [
                            'name'          => 'slick',
                            'src'           => 'assets/css/slick.css',
                            'is_external'   => false
                        ]
                    ]
                ]
            ],

            'iqonic_product_category_slider' => [
                'class' => 'Iqonic\Elementor\Elements\Category_Slider\Widget',
                'dependency' => [
                    'js' => [
                        [
                            'name'          => 'slick-min',
                            'src'           => 'assets/js/slick.min.js',
                            'is_external'   => true
                        ],
                        [
                            'name'          => 'slick-animation',
                            'src'           => 'assets/js/slick-animation.min.js',
                            'is_external'   => true
                        ],
                        [
                            'name'          => 'category',
                            'src'           => 'assets/js/category.js',
                            'is_external'   => false
                        ],
                    ],
                    'css' => [
                        [
                            'name'          => 'slick-theme',
                            'src'           => 'assets/css/slick-theme.css',
                            'is_external'   => false
                        ],
                        [
                            'name'          => 'slick-animation',
                            'src'           => 'assets/css/slick-animation.css',
                            'is_external'   => false
                        ],
                        [
                            'name'          => 'product-category',
                            'src'           => 'assets/css/category.css',
                            'is_external'   => false
                        ]
                    ],
                ]
            ],

            'iqonic_product_category_box' => [
                'class' => 'Iqonic\Elementor\Elements\Category_Box\Widget',
                'dependency' => [
                    'css' => [
                        [
                            'name'          => 'product-category-box',
                            'src'           => 'assets/css/product-category-box.css',
                            'is_external'   => false
                        ]
                    ],
                ]
            ],

            // Cart
            'iqonic_cart' => [
                'class' => 'Iqonic\Elementor\Elements\Cart\Widget',
                'dependency' => [
                    'css' => [
                        [
                            'name'          => 'cart',
                            'src'           => 'assets/css/cart.css',
                            'is_external'   => false
                        ]
                    ],
                ]
            ],

            // WooCoomerce login
            'iqonic_woocommerce_login' => [
                'class' => 'Iqonic\Elementor\Elements\WoocommerceLogin\Widget',
                'dependency' => [
                    'css' => [
                        [
                            'name'          => 'woocommerce-login',
                            'src'           => 'assets/css/woocommerce-login.css',
                            'is_external'   => false
                        ]
                    ],
                ]
            ],
            // -----------------------------WOOCOMMERCE WIDGET ENDS------------------------
        ];

        $config['Elements'] = array_merge($existingElements, $newElements);
        return $config;
    }
}
