<?php

namespace Iqonic\Acf;

class Post
{
    protected $version;
    protected $plugin_name;

    public function __construct()
    {
        $this->plugin_name  = 'streamit-extension';
        $this->version      = defined('STREAMIT_EXTENSION_VERSION') ? STREAMIT_EXTENSION_VERSION : '1.0.0';

        $this->set_general_options();
    }

    public function set_general_options()
    {
        if (function_exists('acf_add_local_field_group')) :
            acf_add_local_field_group(array(
                'key'       => 'group_post_read_time',
                'title'     => 'Post Reading Time',
                'fields'    => array(
                    array(
                        'key'               => 'key_post_read_time',
                        'name'              => '_streamit_post_read_time',
                        'type'              => 'text',
                        'label'             => '',
                        'required'          => 0,
                        'endpoint'          => 0,
                        'conditional_logic' => 0,
                        'placement'         => 'left',
                        'wrapper' => array(
                            'width' => '30%',
                            'class' => '',
                            'id'    => '',
                        ),
                    )
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'post',
                        ),
                    ),
                ),
                'menu_order'            => 0,
                'hide_on_screen'        => '',
                'description'           => '',
                'active'                => true,
                'label_placement'       => 'top',
                'instruction_placement' => 'label',
                'position'              => 'normal',
                'style'                 => 'default',
            ));
        endif;
    }
}
