<?php

namespace Iqonic\Acf;

class PortraitThumbnail
{
    protected $version;
    protected $plugin_name;

    public function __construct()
    {
        $this->plugin_name  = 'streamit-extension';
        $this->version      = defined('STREAMIT_EXTENSION_VERSION') ? STREAMIT_EXTENSION_VERSION : '1.0.0';

        $this->set_general_options();
    }

    public function set_general_options()
    {
        if (function_exists('acf_add_local_field_group')) :
            acf_add_local_field_group(array(
                'key'       => 'group_portrait_thmub',
                'title'     => isset($_GET['post']) ? ucfirst(get_post_type($_GET['post'])) . ' Portrait Image' : esc_html__('Portrait Image', SE_TEXT_DOMAIN),
                'fields'    => array(
                    array(
                        'key'               => 'key_portrait_thumbnail',
                        'name'              => '_portrait_thumbmail',
                        'type'              => 'image',
                        'label'             => '',
                        'instructions'      => 'Preferred size 522 x 760',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'endpoint'          => 0,
                        'placement'         => 'left',
                        'wrapper'           => array(
                            'width' => '20%',
                            'class' => '',
                            'id'    => '',
                        ),
                    )
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'movie',
                        ),
                    ),
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'tv_show',
                        ),
                    ),
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'video',
                        ),
                    ),
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'episode',
                        ),
                    ),
                ),
                'menu_order'            => 0,
                'hide_on_screen'        => '',
                'description'           => '',
                'active'                => true,
                'label_placement'       => 'top',
                'position'              => 'side',
                'instruction_placement' => 'label',
                'style'                 => 'default',
            ));
        endif;
    }
}
