<?php

namespace Iqonic\Acf;

class Page
{
    protected $version;
    protected $plugin_name;

    public function __construct()
    {
        if (defined('STREAMIT_EXTENSION_VERSION')) {
            $this->version = STREAMIT_EXTENSION_VERSION;
        } else {
            $this->version = '1.1.0';
        }
        $this->plugin_name = 'streamit-extension';

        $this->set_general_options();
    }
    public function get_hf_layout($type = 'header')
    {
        $args = array(
            'post_type'         => 'iqonic_hf_layout',
            'post_status'       => 'publish',
            'posts_per_page'    => -1,
            'meta_key'          => '_layout_meta_key',
            'meta_value'        => $type,
        );
        $wp_query = get_posts($args);
        $iqonic_header_list = [];

        if ($wp_query) {
            foreach ($wp_query as $header) {
                $iqonic_header_list[$header->post_name] = $header->post_title;
            }
        }
        return $iqonic_header_list;
    }
    public function set_general_options()
    {
        if (function_exists('acf_add_local_field_group')) :

            // Page Options
            acf_add_local_field_group(array(
                'key' => 'group_banner',
                'title' => 'Page Options',
                'fields' => array(
                    array(
                        'key' => 'key_header_setting',
                        'label' => 'Header setting',
                        'name' => 'header_setting',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_header_display',
                        'label' => 'Display Header',
                        'name' => 'name_header_display',
                        'type' => 'button_group',
                        'allow_null' => 0,
                        'layout' => 'horizontal',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'choices' => array(
                            'default' => 'Default',
                            'yes' => 'Yes',
                            'no' => 'No',
                        ),
                        'wrapper' => array(
                            'width' => '100%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ),

                    array(
                        'key' => 'header_layout_switch',
                        'label' => 'Header Layout',
                        'name' => 'header_layout_type',
                        'type' => 'button_group',
                        'allow_null' => 0,
                        'layout' => 'horizontal',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'key_header_display',
                                    'operator' => '==',
                                    'value' => 'yes',
                                ),
                            ),
                        ),
                        'choices' => array(
                            'default' => 'Default',
                            'custom' => 'Custom',
                        ),
                        'wrapper' => array(
                            'width' => '20%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ),

                    array(
                        'key' => 'header_layout_key',
                        'label' => 'Select Header',
                        'name' => 'header_layout_name',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'header_layout_switch',
                                    'operator' => '==',
                                    'value' => 'custom',
                                ),
                            ),
                        ),
                        'wrapper' => [
                            'width' => '25%',
                            'class' => '',
                            'id' => '',
                        ],
                        'choices' => $this->get_hf_layout(),
                        'default_value' => [],
                        'allow_null' => 0,
                        'multiple' => 0,
                        'ui' => 1,
                        'ajax' => 0,
                        'return_format' => 'value',
                        'placeholder' => '',
                    ),
                    array(
                        'key'               => 'header_position_switch',
                        'label'             => 'Header Position',
                        'name'              => 'header_position',
                        'type'              => 'button_group',
                        'allow_null' => 0,
                        'layout' => 'horizontal',
                        'instructions'      => '',
                        'required'          => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'key_header_display',
                                    'operator' => '==',
                                    'value' => 'yes',
                                ),
                            ),
                        ),
                        'choices' => array(
                            'default'   => 'Default',
                            'over'      => 'Over',
                            'under'     => 'Under',
                        ),
                        'wrapper' => array(
                            'width' => '25%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ),
                    array(
                        'key' => 'field_logo',
                        'label' => 'Logo',
                        'name' => 'header_logo',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'return_format' => 'array',
                        'preview_size' => 'medium',
                        'library' => 'all',
                        'min_width' => '',
                        'min_height' => '',
                        'min_size' => '',
                        'max_width' => '',
                        'max_height' => '',
                        'max_size' => '',
                        'mime_types' => '',
                    ),

                    array(
                        'key' => 'key_banner_setting',
                        'label' => 'Banner setting',
                        'name' => 'banner_setting',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => '',
                        'placement' => 'left',

                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_banner_display',
                        'label' => 'Display Banner',
                        'name' => 'name_banner_display',
                        'type' => 'button_group',
                        'allow_null' => 0,
                        'layout' => 'horizontal',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'choices' => array(
                            'yes' => 'Yes',
                            'no' => 'No',
                        ),
                        'wrapper' => array(
                            'width' => '33.33%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'yes',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ),

                    array(
                        'key' => 'key_footer_setting',
                        'label' => 'Footer setting',
                        'name' => 'footer_setting',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'layout' => '',
                        'placement' => 'left',

                        'endpoint' => 0,
                    ),

                    array(
                        'key' => 'key_footer_display',
                        'label' => 'Display Footer',
                        'name' => 'name_footer_display',
                        'type' => 'button_group',
                        'allow_null' => 0,
                        'layout' => 'horizontal',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'choices' => array(
                            'default' => 'Default',
                            'yes' => 'Yes',
                            'no' => 'No',
                        ),
                        'wrapper' => array(
                            'width' => '100%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ),
                    array(
                        'key' => 'footer_layout_switch',
                        'label' => 'Footer Layout',
                        'name' => 'footer_layout_type',
                        'type' => 'button_group',
                        'allow_null' => 0,
                        'layout' => 'horizontal',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'key_footer_display',
                                    'operator' => '==',
                                    'value' => 'yes',
                                ),
                            ),
                        ),
                        'choices' => array(
                            'default' => 'Default',
                            'custom' => 'Custom',
                        ),
                        'wrapper' => array(
                            'width' => '20%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ),
                    array(
                        'key' => 'footer_layout_key',
                        'label' => 'Select Footer',
                        'name' => 'footer_layout_name',
                        'type' => 'select',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'footer_layout_switch',
                                    'operator' => '==',
                                    'value' => 'custom',
                                ),
                            ),
                        ),
                        'wrapper' => [
                            'width' => '33.33%',
                            'class' => '',
                            'id' => '',
                        ],
                        'choices' => $this->get_hf_layout('footer'),
                        'default_value' => [],
                        'allow_null' => 0,
                        'multiple' => 0,
                        'ui' => 1,
                        'ajax' => 0,
                        'return_format' => 'value',
                        'placeholder' => '',
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param' => 'post_type',
                            'operator' => '==',
                            'value' => 'page',
                        ),
                    ),
                ),
                'menu_order' => 0,
                'position' => 'normal',
                'style' => 'default',
                'label_placement' => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen' => '',
                'active' => true,
                'description' => '',
            ));
        endif;
    }
}
