<?php

namespace Iqonic\Acf;

class Meta
{
    protected $version;
    protected $plugin_name;

    public function __construct()
    {
        $this->plugin_name  = 'streamit-extension';
        $this->version      = defined('STREAMIT_EXTENSION_VERSION') ? STREAMIT_EXTENSION_VERSION : '1.0.0';

        $this->set_general_options();

        add_filter('manage_edit-tv_show_genre_columns',  array($this, 'tv_show_genre_column_views'));
        add_action('manage_tv_show_genre_custom_column', array($this, 'tv_show_genre_custom_column_content'), 10, 3);
    }

    public function set_general_options()
    {
        if (function_exists('acf_add_local_field_group')) :
            acf_add_local_field_group(array(
                'key'       => 'tv_show_thumbnail_images',
                'title'     => 'Thumbnail',
                'fields'    => array(
                    array(
                        'key'               => 'key_tv_show_genres_image', //key_movie_logo
                        'name'              => 'thumbnail_id', //movie_logo
                        'type'              => 'image',
                        'label'             => 'Thumbnail',
                        'instructions'      => '',
                        'endpoint'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'taxonomy',
                            'operator'  => '==',
                            'value'     => 'tv_show_genre',
                        ),
                    )
                ),
                'menu_order'            => 0,
                'position'              => 'normal',
                'style'                 => 'default',
                'label_placement'       => 'top',
                'instruction_placement' => 'label',
                'hide_on_screen'        => '',
                'active'                => true,
                'description'           => '',
            ));
        endif;
    }

    function tv_show_genre_column_views($columns)
    {
        $new_columns = array();

        if (isset($columns['cb'])) {
            $new_columns['cb'] = $columns['cb'];
            unset($columns['cb']);
        }

        $new_columns['thumb'] = esc_html__('Image', SE_TEXT_DOMAIN);

        $columns = array_merge($new_columns, $columns);

        return $columns;
    }

    function tv_show_genre_custom_column_content($columns, $column, $id)
    {
        if ('thumb' === $column) {

            $thumbnail_id = get_term_meta($id, 'thumbnail_id', true);

            if ($thumbnail_id && !empty(wp_get_attachment_thumb_url($thumbnail_id))) {
                $image = wp_get_attachment_thumb_url($thumbnail_id);
            } else {
                $image = STREAMIT_EXTENSION_PLUGIN_URL . '/includes/Elementor/assets/img/placeholder_genre.jpg';
            }
            $image    = str_replace(' ', '%20', $image);
            $columns .= '<img src="' . esc_url($image) . '" alt="' . esc_attr__('Thumbnail', SE_TEXT_DOMAIN) . '" class="wp-post-image" height="48" width="48" />';
        }
        return $columns;
    }
}
