<?php

namespace Iqonic\Acf;

class General
{
    protected $get_option;
    protected $version;
    protected $plugin_name;

    public function __construct()
    {
        $this->plugin_name  = 'streamit-extension';
        $this->version      = defined('STREAMIT_EXTENSION_VERSION') ? STREAMIT_EXTENSION_VERSION : '1.0.0';

        $this->get_option = get_option('streamit_options');
        $this->set_general_options();
    }

    public function set_general_options()
    {
        if (function_exists('acf_add_local_field_group')) :

            $is_streamit_viewcounter_set = isset($this->get_option['streamit_viewcounter_option']) && $this->get_option['streamit_viewcounter_option'] == 'yes';
            acf_add_local_field_group(array(
                'key'       => 'group_46Cg7N74r8t811VLFfR6',
                'title'     => 'Additional Data',
                'fields'    => array(
                    array(
                        'key'               => 'field_sth54fsf22fsd',
                        'name'              => 'body_set',
                        'type'              => 'tab',
                        'label'             => 'Additional Data',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'endpoint'          => 0,
                        'instructions'      => '',
                        'placement'         => 'left',
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                    array(
                        'key'               => 'key_logo',
                        'name'              => 'name_logo',
                        'type'              => 'image',
                        'label'             => 'Logo',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'endpoint'          => 0,
                        'instructions'      => '',
                        'placement'         => 'left',
                        'wrapper'           => array(
                            'width' => '100%',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                    array(
                        'key'               => 'key_trailer_img',
                        'name'              => 'name_trailer_img',
                        'type'              => 'image',
                        'label'             => 'Trailer Image',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'endpoint'          => 0,
                        'instructions'      => '',
                        'placement'         => 'left',
                        'wrapper'           => array(
                            'width' => '25%',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                    array(
                        'key'               => 'key_trailer_link',
                        'name'              => 'name_trailer_link',
                        'type'              => 'text',
                        'label'             => 'Trailer Link',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'endpoint'          => 0,
                        'instructions'      => '',
                        'placement'         => 'left',
                        'wrapper'           => array(
                            'width' => '75%',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),

                    $is_streamit_viewcounter_set ? array(
                        'key'               => 'acf_key_set_view_counter_number',
                        'name'              => 'post_views_count',
                        'type'              => 'number',
                        'label'             => 'Start View Counter',
                        'placeholder'       => 'Enter Initialize Counter',
                        'required'          => 0,
                        'disabled'          => 0,
                        'ui'                => 1,
                        'instructions'      => '',
                        'message'           => '',
                        'ui_on_text'        => '',
                        'ui_off_text'       => '',
                        'default_value'     => 'default',
                        'wrapper'           => array(
                            'width' => '25%',
                            'class' => '',
                            'id'    => '',
                        ),
                    ) : array(),

                    array(
                        'key'               => 'select_related_product',
                        'name'              => 'related_product',
                        'type'              => 'select',
                        'label'             => 'Select Related Product',
                        'choices'           => function_exists('iq_custom_post_data') ? iq_custom_post_data('product', false) : false,
                        'conditional_logic' => 0,
                        'allow_null'        => 0,
                        'ajax'              => 0,
                        'multiple'          => 1,
                        'ui'                => 1,
                        'default_value'     => [],
                        'instructions'      => '',
                        'placeholder'       => '',
                        'return_format'     => 'value',
                        'wrapper'           => array(
                            'width' => '75%',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                    array(
                        'key'               => 'key_upcoming',
                        'name'              => 'name_upcoming',
                        'type'              => 'checkbox',
                        'label'             => 'Upcoming',
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'instructions'      => '',
                        'toggle'            => false,
                        'layout'            => 'vertical',
                        'return_format'     => 'value',
                        'wrapper'           => array(
                            'width' => '25%',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices'           => array(
                            'yes' => __('Is Upcoming ' . ucfirst(get_post_type($_GET['post'])), SE_TEXT_DOMAIN)
                        ),
                    ),
                    array(
                        'key'               => 'key_download_btn',
                        'name'              => 'download_btn',
                        'type'              => 'button_group',
                        'label'             => 'Show Download Button',
                        'allow_null'        => 0,
                        'required'          => 0,
                        'ui'                => 1,
                        'instructions'      => '',
                        'message'           => '',
                        'ui_on_text'        => '',
                        'ui_off_text'       => '',
                        'default_value'     => 'default',
                        'layout'            => 'horizontal',
                        'choices'           => array(
                            'no'     => 'No',
                            'link'   => 'Link',
                            'upload' => 'Upload',
                        ),
                        'wrapper'           => array(
                            'width' => '20%',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                    array(
                        'key'               => 'key_dwn_link',
                        'name'              => 'dwn_link',
                        'type'              => 'text',
                        'label'             => 'Dwonload Link ',
                        'instructions'      => '',
                        'required'          => 0,
                        'endpoint'          => 0,
                        'placement'         => 'left',
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field'     => 'key_download_btn',
                                    'operator'  => '==',
                                    'value'     => 'link',
                                ),
                            ),
                        ),
                        'wrapper'           => array(
                            'width' => '50%',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                    array(
                        'key'               => 'key_upload_item',
                        'name'              => 'upload_item',
                        'type'              => 'file',
                        'label'             => 'Uploaded',
                        'required'          => 0,
                        'endpoint'          => 0,
                        'instructions'      => '',
                        'placement'         => 'left',
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field'     => 'key_download_btn',
                                    'operator'  => '==',
                                    'value'     => 'upload',
                                ),
                            ),
                        ),
                        'wrapper'           => array(
                            'width' => '50%',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'movie',
                        ),
                    ),
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'tv_show',
                        ),
                    ),
                ),
                'menu_order'            => 0,
                'hide_on_screen'        => '',
                'description'           => '',
                'active'                => true,
                'label_placement'       => 'top',
                'instruction_placement' => 'label',
                'position'              => 'normal',
                'style'                 => 'default',
            ));

            // Streamit custom imdb rating
            acf_add_local_field_group(array(
                'key' => 'group_46Cg8t811VsdLFfR6',
                'title' => 'Rating',
                'fields' => array(
                    array(
                        'key' => 'key_custom_imdb_rating',
                        'label' => 'Enter IMDB rating manually',
                        'name' => 'name_custom_imdb_rating',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => [
                            'width' => '20%',
                            'class' => '',
                            'id' => '',
                        ],
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'min' => '1',
                        'max' => '10',
                        'step' => ''
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'movie',
                        ),
                    ),
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'tv_show',
                        ),
                    ),
                ),
                'menu_order'            => 1,
                'hide_on_screen'        => '',
                'description'           => '',
                'active'                => true,
                'label_placement'       => 'top',
                'instruction_placement' => 'label',
                'position'              => 'normal',
                'style'                 => 'default',
            ));

            // Page video Options
            acf_add_local_field_group(array(
                'key' => 'group_46Cg8t811VLFfR6',
                'title' => 'Additional Data',
                'fields' => array(
                    array(
                        'key' => 'field_sth54fsf22fsd',
                        'label' => 'Additional Data',
                        'name' => 'body_set',
                        'type' => 'tab',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_logo',
                        'label' => 'Logo',
                        'name' => 'name_logo',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '20%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_trailer_link',
                        'label' => 'Trailer Link',
                        'name' => 'name_trailer_link',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_trailer_img',
                        'label' => 'Trailer Image',
                        'name' => 'name_trailer_img',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_video_run_time',
                        'label' => 'Video Time Duration',
                        'name' => '_video_run_time',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '75%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    $is_streamit_viewcounter_set ? array(
                        'key'               => 'acf_key_set_view_counter_number',
                        'label'             => 'Start View Counter',
                        'name'              => 'post_views_count',
                        'type'              => 'number',
                        'instructions'      => '',
                        'required'          => 0,
                        'disabled' => 0,
                        'wrapper' => array(
                            'width' => '25%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placeholder' => 'Enter Initialize Counter',
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ) : array(),
                    array(
                        'key' => 'select_related_product',
                        'label' => 'Select Related Product',
                        'name' => 'related_product',
                        'type' => 'select',
                        'instructions' => '',
                        'wrapper' => [
                            'width' => '75%',
                            'class' => '',
                            'id' => '',
                        ],
                        'conditional_logic' => 0,
                        'choices' => function_exists('iq_custom_post_data') ? iq_custom_post_data('product', false) : false,
                        'default_value' => [],
                        'allow_null' => 0,
                        'multiple' => 1,
                        'ui' => 1,
                        'ajax' => 0,
                        'return_format' => 'value',
                        'placeholder' => '',
                    ),
                    array(
                        'key' => 'key_upcoming',
                        'label' => 'Upcoming',
                        'name' => 'name_upcoming',
                        'type' => 'checkbox',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '35%',
                            'class' => '',
                            'id' => '',
                        ),
                        'choices' => array(
                            'yes' => __('Is upcoming ' . ucfirst(get_post_type($_GET['post'])), SE_TEXT_DOMAIN)
                        ),
                        'layout' => 'vertical',
                        'toggle' => false,
                        'return_format' => 'array',
                    ),
                    array(
                        'key' => 'key_download_btn',
                        'label' => 'Show Download Button',
                        'name' => 'download_btn',
                        'type' => 'button_group',
                        'allow_null' => 0,
                        'layout' => 'horizontal',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'choices' => array(
                            'no' => 'No',
                            'link' => 'Link',
                            'upload' => 'Upload',
                        ),
                        'wrapper' => array(
                            'width' => '35%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ),
                    array(
                        'key' => 'key_dwn_link',
                        'label' => 'Dwonload Link ',
                        'name' => 'dwn_link',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'key_download_btn',
                                    'operator' => '==',
                                    'value' => 'link',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_upload_item',
                        'label' => 'Uploaded',
                        'name' => 'upload_item',
                        'type' => 'file',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'key_download_btn',
                                    'operator' => '==',
                                    'value' => 'upload',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'video',
                        ),
                    ),
                ),
                'menu_order'            => 0,
                'hide_on_screen'        => '',
                'description'           => '',
                'active'                => true,
                'label_placement'       => 'top',
                'instruction_placement' => 'label',
                'position'              => 'normal',
                'style'                 => 'default',
            ));

            // Page episode Options
            acf_add_local_field_group(array(
                'key' => 'group_46122Cg8t811VLFfR6',
                'title' => 'Additional Data',
                'fields' => array(
                    array(
                        'key' => 'key_custom_imdb_rating',
                        'label' => 'Enter IMDB rating manually',
                        'name' => 'name_custom_imdb_rating',
                        'type' => 'number',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => [
                            'width' => '20%',
                            'class' => '',
                            'id' => '',
                        ],
                        'default_value' => '',
                        'placeholder' => '',
                        'prepend' => '',
                        'append' => '',
                        'min' => '1',
                        'max' => '10',
                        'step' => ''
                    ),
                    array(
                        'key' => 'key_trailer_link',
                        'label' => 'Trailer Link',
                        'name' => 'name_trailer_link',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '50%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),

                    array(
                        'key' => 'key_trailer_img',
                        'label' => 'Trailer Image',
                        'name' => 'name_trailer_img',
                        'type' => 'image',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'wrapper' => array(
                            'width' => '30%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    isset($this->get_option['streamit_viewcounter_option']) && $this->get_option['streamit_viewcounter_option'] == 'yes' ? array(
                        'key'               => 'acf_key_set_view_counter_number',
                        'label'             => 'Start View Counter',
                        'name'              => 'post_views_count',
                        'type'              => 'number',
                        'instructions'      => '',
                        'required'          => 0,
                        'disabled' => 0,
                        'wrapper' => array(
                            'width' => '25%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    )
                        : array(),
                    array(
                        'key' => 'key_download_btn',
                        'label' => 'Show Download Button',
                        'name' => 'download_btn',
                        'type' => 'button_group',
                        'allow_null' => 0,
                        'layout' => 'horizontal',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => 0,
                        'choices' => array(
                            'no' => 'No',
                            'link' => 'Link',
                            'upload' => 'Upload',
                        ),
                        'wrapper' => array(
                            'width' => '34%',
                            'class' => '',
                            'id' => '',
                        ),
                        'message' => '',
                        'default_value' => 'default',
                        'ui' => 1,
                        'ui_on_text' => '',
                        'ui_off_text' => '',
                    ),
                    array(
                        'key' => 'key_dwn_link',
                        'label' => 'Dwonload Link ',
                        'name' => 'dwn_link',
                        'type' => 'text',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'key_download_btn',
                                    'operator' => '==',
                                    'value' => 'link',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                    array(
                        'key' => 'key_upload_item',
                        'label' => 'Uploaded',
                        'name' => 'upload_item',
                        'type' => 'file',
                        'instructions' => '',
                        'required' => 0,
                        'conditional_logic' => array(
                            array(
                                array(
                                    'field' => 'key_download_btn',
                                    'operator' => '==',
                                    'value' => 'upload',
                                ),
                            ),
                        ),
                        'wrapper' => array(
                            'width' => '50%',
                            'class' => '',
                            'id' => '',
                        ),
                        'placement' => 'left',
                        'endpoint' => 0,
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'episode',
                        ),
                    ),
                ),
                'menu_order'            => 0,
                'hide_on_screen'        => '',
                'description'           => '',
                'active'                => true,
                'label_placement'       => 'top',
                'instruction_placement' => 'label',
                'position'              => 'normal',
                'style'                 => 'default',
            ));
        endif;
    }
}
