<?php

namespace Iqonic\Acf;

class Cast
{
    protected $version;
    protected $plugin_name;

    public function __construct()
    {
        $this->plugin_name  = 'streamit-extension';
        $this->version      = defined('STREAMIT_EXTENSION_VERSION') ? STREAMIT_EXTENSION_VERSION : '1.0.0';

        $this->set_cast_custom_fields();
    }

    public function set_cast_custom_fields()
    {
        if (function_exists('acf_add_local_field_group')) {
            acf_add_local_field_group(array(
                'key'       => 'cast_personal_details',
                'title'     => esc_html__('Personal Details', SE_TEXT_DOMAIN),
                'fields'    => array(
                    array(
                        'type'              => 'text',
                        'name'              => 'cast_awards',
                        'key'               => '_cast_awards',
                        'label'             => esc_html__('Awards', SE_TEXT_DOMAIN),
                        'prefix'            => '',
                        'instructions'      => '',
                        'placeholder'       => '',
                        'prepend'           => '',
                        'append'            => '',
                        'maxlength'         => '',
                        'default_value'     => '',
                        'readonly'          => 0,
                        'disabled'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'id'    => '',
                            'width' => '50%',
                            'class' => '',
                        ),
                    ),
                    array(
                        'type'              => 'text',
                        'name'              => 'cast_official_site',
                        'key'               => '_cast_official_site',
                        'label'             => esc_html__('Offical Site', SE_TEXT_DOMAIN),
                        'prefix'            => '',
                        'instructions'      => '',
                        'placeholder'       => '',
                        'prepend'           => '',
                        'append'            => '',
                        'maxlength'         => '',
                        'default_value'     => '',
                        'readonly'          => 0,
                        'disabled'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'width' => '',
                            'width' => '50%',
                            'id'    => '',
                        ),
                    ),
                    array(
                        'type'              => 'text',
                        'name'              => 'cast_height',
                        'key'               => '_cast_height',
                        'label'             => esc_html__('Height', SE_TEXT_DOMAIN),
                        'prefix'            => '',
                        'instructions'      => '',
                        'placeholder'       => '',
                        'prepend'           => '',
                        'append'            => '',
                        'maxlength'         => '',
                        'default_value'     => '',
                        'readonly'          => 0,
                        'disabled'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'id'    => '',
                            'width' => '50%',
                            'class' => '',
                        ),
                    ),
                    array(
                        'type'              => 'text',
                        'name'              => 'cast_relatives',
                        'key'               => '_cast_relatives',
                        'label'             => esc_html__('Relatives', SE_TEXT_DOMAIN),
                        'prefix'            => '',
                        'instructions'      => '',
                        'placeholder'       => '',
                        'prepend'           => '',
                        'append'            => '',
                        'maxlength'         => '',
                        'default_value'     => '',
                        'readonly'          => 0,
                        'disabled'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'id'    => '',
                            'width' => '50%',
                            'class' => '',
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'post_type',
                            'operator'  => '==',
                            'value'     => 'person',
                        ),
                    ),
                ),
                'menu_order'            => 0,
                'description'           => '',
                'hide_on_screen'        => '',
                'active'                => true,
                'label_placement'       => 'top',
                'instruction_placement' => 'label',
                'position'              => 'normal',
                'style'                 => 'default',
            ));
        }
    }
}
