<?php

namespace Iqonic\Acf;

class Author
{
    protected $version;
    protected $plugin_name;

    public function __construct()
    {
        if (defined('STREAMIT_EXTENSION_VERSION')) {
            $this->version = STREAMIT_EXTENSION_VERSION;
        } else {
            $this->version = '1.0.0';
        }
        $this->plugin_name = 'streamit-extension';

        $this->set_author_custom_options();
    }

    public function set_author_custom_options()
    {
        if (function_exists('acf_add_local_field_group')) {
            acf_add_local_field_group(array(
                'key'       => 'group_social',
                'title'     => esc_html__('Social Media Links', SE_TEXT_DOMAIN),
                'fields'    => array(
                    array(
                        'type'              => 'text',
                        'name'              => 'facebook_url',
                        'key'               => 'field_facebook',
                        'label'             => esc_html__('Facebook', SE_TEXT_DOMAIN),
                        'prefix'            => '',
                        'instructions'      => '',
                        'placeholder'       => '',
                        'prepend'           => '',
                        'append'            => '',
                        'maxlength'         => '',
                        'default_value'     => '#',
                        'readonly'          => 0,
                        'disabled'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'width' => '',
                            'class' => '',
                            'id'    => '',
                        ),
                    ),
                    array(
                        'type'              => 'text',
                        'name'              => 'instagram_url',
                        'key'               => 'field_instagram',
                        'label'             => esc_html__('Instagram', SE_TEXT_DOMAIN),
                        'prefix'            => '',
                        'instructions'      => '',
                        'placeholder'       => '',
                        'prepend'           => '',
                        'append'            => '',
                        'maxlength'         => '',
                        'default_value'     => '#',
                        'readonly'          => 0,
                        'disabled'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'id'    => '',
                            'width' => '',
                            'class' => '',
                        ),
                    ),
                    array(
                        'type'              => 'text',
                        'name'              => 'twitter_url',
                        'key'               => 'field_twitter',
                        'label'             => esc_html__('Twitter', SE_TEXT_DOMAIN),
                        'prefix'            => '',
                        'instructions'      => '',
                        'placeholder'       => '',
                        'prepend'           => '',
                        'append'            => '',
                        'maxlength'         => '',
                        'default_value'     => '#',
                        'readonly'          => 0,
                        'disabled'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'id'    => '',
                            'width' => '',
                            'class' => '',
                        ),
                    ),
                    array(
                        'type'              => 'text',
                        'name'              => 'dribble_url',
                        'key'               => 'field_dribble',
                        'label'             => esc_html__('Dribble', SE_TEXT_DOMAIN),
                        'prefix'            => '',
                        'instructions'      => '',
                        'placeholder'       => '',
                        'prepend'           => '',
                        'append'            => '',
                        'maxlength'         => '',
                        'default_value'     => '#',
                        'readonly'          => 0,
                        'disabled'          => 0,
                        'required'          => 0,
                        'conditional_logic' => 0,
                        'wrapper'           => array(
                            'id'    => '',
                            'width' => '',
                            'class' => '',
                        ),
                    ),
                ),
                'location' => array(
                    array(
                        array(
                            'param'     => 'user_form',
                            'operator'  => '==',
                            'value'     => 'edit',
                        ),
                    ),
                ),
                'menu_order'            => 0,
                'description'           => '',
                'hide_on_screen'        => '',
                'active'                => true,
                'label_placement'       => 'top',
                'instruction_placement' => 'label',
                'position'              => 'normal',
                'style'                 => 'default',
            ));
        }
    }
}
