<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
</head>

<body>
    <div class="container-fluid">
        <div class="row mt-3 mb-3">
            <div class="col-md-12">
                <h4 class="streamit-text"> Streamit multiplatform content import </h4>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <div class="alert alert-warning alert-dismissible fade show d-none" id="youtube-free-quota-limit" role="alert">
                    <span id="youtube-free-quota-limit-message"></span>
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                        <span aria-hidden="true">×</span>
                    </button>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-md-12">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#home" role="tab" aria-controls="home" aria-selected="true">External Data Import</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link " id="profile-tab" data-bs-toggle="tab" href="#profile" role="tab" aria-controls="profile" aria-selected="false">General Setting</a>
                    </li>
                </ul>
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active mt-2" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="mt-3">
                            <div class="row">
                                <div class="col-md-1">
                                    <div class="form-group">
                                        <select class="form-control" id="streamit-result-limit">
                                            <option value="5"> 5 </option>
                                            <option value="10" selected> 10 </option>
                                            <option value="15"> 15 </option>
                                            <option value="20"> 25 </option>
                                            <option value="30"> 30 </option>
                                            <option value="40"> 40 </option>
                                            <option value="50"> 50</option>
                                            <option value="100"> 100</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <div class="form-group">
                                        <?php
                                        $image_id = get_option('myprefix_image_id');
                                        if (intval($image_id) > 0) {
                                            // Change with the image size you want to use
                                            $image = wp_get_attachment_image($image_id, 'medium', false, array('id' => 'myprefix-preview-image'));
                                        } else {
                                            // Some default image
                                            $image = '<img id="myprefix-preview-image" src="https://some.default.image.jpg" />';
                                        }
                                        ?>
                                        <select class="form-control" id="streamit-import-type">
                                            <option value="" selected> Select Import Provider </option>
                                            <?php

                                            if (isset($developer_key['youtube_status']) && $developer_key['youtube_status'] === 'on') {
                                                echo  '<option value="video_youtube">  Video From Youtube  </option>';
                                                echo  '<option value="movie_youtube">  Movie From Youtube  </option>';
                                            }

                                            if (isset($developer_key['vimeo_status']) && $developer_key['vimeo_status'] === 'on') {
                                                echo  '<option value="video_vimeo">  Video From Vimeo    </option> ';
                                            }

                                            if (isset($developer_key['omdb_status']) && $developer_key['omdb_status'] === 'on') {
                                                echo  '<option value="movie_omdb">  Movie From OMDB </option> ';
                                            }

                                            if (isset($developer_key['tmdb_status']) && $developer_key['tmdb_status'] === 'on') {
                                                echo  '<option value="movie_tmdb">  Movie From TMDB </option> ';
                                            }

                                            ?>

                                            <option value="csv_import"> CSV </option>

                                        </select>

                                    </div>
                                </div>
                                <div class="col-md-3" id="language-hide-show" style="display: none;">
                                    <div class="form-group">

                                        <?php wp_dropdown_languages(array(
                                            'id' => 'streamit-tmdb-language',
                                            'name' => 'streamit-tmdb-language',
                                            'selected' => get_locale()
                                        )); ?>

                                    </div>
                                </div>
                                <div class="col-md-3 d-none" id="streamit-csv-type">
                                    <div class="form-group d-block">
                                        <select class="form-control" id="streamit-content-csv-import-type">
                                            <option value="movie_import" selected> Import Movie From CSV </option>
                                            <option value="video_import"> Import Video From CSV </option>
                                        </select>
                                        <a href="<?php echo STREAMIT_EXTENSION_PLUGIN_URL; ?>/feature/demo-movie.csv" id="streamit-demo-movie-csv-download" class="streamit-demo-movie-csv d-none ml-3 " download> Click here to download demo movie csv </a>
                                        <a href="<?php echo STREAMIT_EXTENSION_PLUGIN_URL; ?>/feature/demo-video.csv" id="streamit-demo-video-csv-download" class="streamit-demo-video-csv d-none ml-3" download> Click here to download demo video csv </a>
                                    </div>
                                </div>
                                <div class="col-md-2 d-none" id="youtube-channel-section">
                                    <div class="form-group">
                                        <form id='streamit-csv-upload' enctype="multipart/form-data">
                                            <input id="stremit-youtube-channel-search" class="form-control " type="text" placeholder="Search channel id">
                                        </form>
                                    </div>
                                </div>
                                <div class="col-md-2 d-none" id="streamit-file-upload">
                                    <div class="form-group">
                                        <button type="button" class="btn streamit-import-btn mb-2 mr-2" name="streamit-csv-file" id="streamit-file-upload"> Click here to upload csv </button>
                                    </div>
                                </div>
                                <div class="col-md-2" id="search-keyword-section">
                                    <div class="form-group">
                                        <input id="stremit-search" class="form-control" type="text" placeholder="Search keyword">
                                    </div>
                                </div>
                                <div class="col-md-3">
                                    <input type="hidden" name="myprefix_image_id" id="myprefix_image_id" value="<?php echo esc_attr($image_id); ?>" class="regular-text" />
                                    <!-- <button type="button" id='streamit-csv-upload-btn' class="btn btn-primary mb-2 mr-2 d-none"> upload </button> -->
                                    <button type="button" id='streamit-search-btn' class="btn mb-2 "> Search </button>
                                    <button type="button" id='streamit-import-btn' class="btn mb-2 ml-2 streamit-import-btn"> Import </button>
                                </div>
                                <!-- <a href="<?php echo STREAMIT_EXTENSION_PLUGIN_URL; ?>/feature/demo-movie.csv" id="streamit-demo-movie-csv-download" class="streamit-demo-movie-csv d-none ml-3 " download > Click here to download demo movie csv </a>
                                <a href="<?php echo STREAMIT_EXTENSION_PLUGIN_URL; ?>/feature/demo-video.csv" id="streamit-demo-video-csv-download" class="streamit-demo-video-csv d-none ml-3" download > Click here to download demo video csv </a> -->
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <div class="alert alert-success alert-dismissible fade show d-none" id='streamit-data-success' role="alert">
                                        <strong> Success! </strong> Data import process is successfully completed.
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="alert alert-warning alert-dismissible fade show d-none" id='streamit-data-select-warn' role="alert">
                                        Please select atleast one row before click on import button.
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="alert alert-warning alert-dismissible fade show d-none" id='streamit-data-csv-read-fail-warning' role="alert">
                                        Fail to read csv.
                                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <table class="table table-hover" border=2 width="80%" id='streamit-data-search-result'>
                                        <thead class="thead-dark">
                                            <tr>
                                                <th colspan=4 style="text-align:center"> Search Content </th>
                                            </tr>
                                            <tr>
                                                <th>
                                                    <div class="form-group">
                                                        <input type="checkbox" id="streamit-import-check-all">
                                                    </div>
                                                </th>
                                                <th> Thumbnail </th>
                                                <th> Title </th>
                                                <th> Channel </th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <tr id='streamit-data-loader' class="d-none">
                                                <td colspan=4 style="text-align:center">
                                                    <?php if (isset($default['loader_url'])) { ?>
                                                        <img src="<?php echo $default['loader_url']; ?>">
                                                    <?php  } ?>
                                                </td>
                                            </tr>
                                            <tr id='streamit-no-data-tr'>
                                                <td colspan=4 style="text-align:center"> No content found. </td>
                                            </tr>
                                        </tbody>
                                        <tfoot>
                                            <!-- <tr id='dynamic-data-footer'>
                                                <td colspan=4 style="text-align:right">
                                                    <button type="button" id="youtube-prev-btn" class="btn btn-primary mb-2"> <i class="fas fa-chevron-left"></i> Prev </button>
                                                    <button type="button" id="youtube-next-btn" class="btn btn-primary mb-2">  Next <i class="fas fa-chevron-right"></i> </button>
                                                </td>
                                            </tr> -->
                                        </tfoot>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane fade mt-2" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <div>
                            <div class="alert alert-success alert-dismissible fade show d-none" id='streamit-developer-key-success' role="alert">
                                <strong> Success! </strong> Developer key saved successfully.
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-3 p-3 mt-3">
                                <div class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">
                                    <a class="nav-link active" id="v-pills-home-tab" data-toggle="pill" href="#v-pills-home" role="tab" aria-controls="v-pills-home" aria-selected="true"> YouTube </a>
                                    <!-- <a class="nav-link" id="v-pills-profile-tab" data-toggle="pill" href="#v-pills-profile" role="tab" aria-controls="v-pills-profile" aria-selected="false"> IMDB </a> -->
                                    <a class="nav-link" id="v-pills-messages-tab" data-toggle="pill" href="#v-pills-messages" role="tab" aria-controls="v-pills-messages" aria-selected="false"> Vimeo </a>
                                    <a class="nav-link" id="v-pills-omdb-tab" data-toggle="pill" href="#v-pills-omdb" role="tab" aria-controls="v-pills-omdb" aria-selected="false"> OMDB </a>
                                    <a class="nav-link" id="v-pills-profile-tab" data-toggle="pill" href="#v-pills-profile" role="tab" aria-controls="v-pills-profile" aria-selected="false"> TMDB </a>
                                </div>
                            </div>
                            <div class="col-9 p-3 mt-3">
                                <div class="tab-content" id="v-pills-tabContent">
                                    <div class="tab-pane fade show active" id="v-pills-home" role="tabpanel" aria-labelledby="v-pills-home-tab">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <form>
                                                    <div class="custom-control custom-switch">
                                                        <input type="checkbox" name="youtube-checkbox" class="custom-control-input" id="youtube-checkbox" <?php echo (isset($developer_key['youtube_status']) && $developer_key['youtube_status'] === 'on' ? 'checked' : ''); ?>>
                                                        <label class="custom-control-label" for="youtube-checkbox"> YouTube API Key ( On/Off ) </label>
                                                        <a href="https://developers.google.com/youtube/v3/getting-started" class="api-link ml-3" target="_blank"> Detail guide for get api key </a>
                                                    </div>
                                                    <div class="form-group mt-2">
                                                        <input type="password" class="form-control developer-key-input" id="youtube-developer-key" data-type='youtube' placeholder="Youtube developer key" value="<?php echo isset($developer_key['youtube']) ? $developer_key['youtube'] : ''; ?>">
                                                    </div>
                                                    <button type="button" class="btn streamit-import-btn key-save-btn" data-type="youtube"> Save </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="v-pills-profile" role="tabpanel" aria-labelledby="v-pills-profile-tab">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <form>
                                                    <div class="custom-control custom-switch">
                                                        <input type="checkbox" name="tmdb-status" class="custom-control-input" id="tmdb-checkbox" <?php echo (isset($developer_key['tmdb_status']) && $developer_key['tmdb_status'] === 'on' ? 'checked' : ''); ?>>
                                                        <label class="custom-control-label" for="tmdb-checkbox"> TMDB API Key ( On/Off ) </label>
                                                        <a href="https://www.themoviedb.org/settings/api/" target="_blank" class="api-link ml-3"> Detail guide for get access token </a>
                                                    </div>
                                                    <div class="form-group mt-2">
                                                        <input type="password" class="form-control developer-key-input" id="tmdb-developer-key" placeholder="TMDB developer key" data-type='tmdb' value="<?php echo isset($developer_key['tmdb']) ? $developer_key['tmdb'] : ''; ?>">
                                                    </div>
                                                    <button type="button" class="btn streamit-import-btn key-save-btn" data-type="tmdb"> Save </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="v-pills-messages" role="tabpanel" aria-labelledby="v-pills-messages-tab">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <form>
                                                    <div class="custom-control custom-switch">
                                                        <input type="checkbox" name="vimeo-checkbox" class="custom-control-input" id="vimeo-checkbox" <?php echo (isset($developer_key['vimeo_status']) && $developer_key['vimeo_status'] === 'on' ? 'checked' : ''); ?>>
                                                        <label class="custom-control-label" for="vimeo-checkbox"> Vimeo access token ( On/Off ) </label>
                                                        <a href="https://developer.vimeo.com/api/guides/start" target="_blank" class="api-link ml-3"> Detail guide for get access token </a>
                                                    </div>
                                                    <div class="form-group mt-2">
                                                        <input type="password" class="form-control developer-key-input" data-type='vimeo' id="vimeo-developer-key" placeholder="Vimeo developer key" value="<?php echo isset($developer_key['vimeo']) ? $developer_key['vimeo'] : ''; ?>">
                                                    </div>
                                                    <button type="button" class="btn streamit-import-btn key-save-btn " data-type="vimeo"> Save </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="tab-pane fade" id="v-pills-omdb" role="tabpanel" aria-labelledby="v-pills-messages-tab">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <form>
                                                    <div class="custom-control custom-switch">
                                                        <input type="checkbox" name="omdb-checkbox" class="custom-control-input" id="omdb-checkbox" <?php echo (isset($developer_key['omdb_status']) && $developer_key['omdb_status'] === 'on' ? 'checked' : ''); ?>>
                                                        <label class="custom-control-label" for="omdb-checkbox"> OMDB API Key ( On/Off ) </label>
                                                        <a href="http://www.omdbapi.com/" target="_blank" class="api-link ml-3"> Detail guide for get api key </a>
                                                    </div>
                                                    <div class="form-group mt-2">
                                                        <input type="password" class="form-control developer-key-input" data-type='omdb' id="omdb-developer-key" placeholder="OMDB developer key" value="<?php echo isset($developer_key['omdb']) ? $developer_key['omdb'] : ''; ?>">
                                                    </div>
                                                    <button type="button" class="btn streamit-import-btn key-save-btn" data-type="omdb"> Save </button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>

<script>

</script>