<?php

class ClassStreamitDataImport
{

    public function saveDeveloperKey()
    {

        if (isset($_POST['key']) && isset($_POST['type'])) {

            $success = update_option('streamit_' . $_POST['type'] . '_auth', $_POST['key']);
            $status  = update_option('streamit_' . $_POST['type'] . '_status', $_POST['status']);

            if ($success) {
                echo json_encode(array('status' => true, 'message' => $_POST['type'] . ' API Key updated successfully.'));
                die;
            } else {
                echo json_encode(array('status' => false, 'message' => $_POST['type'] .  ' API Key not updated successfully.',));
                die;
            }
        }
    }

    function importUrlToMedia($url, $id)
    {
        $temp_file = download_url($url, 10);

        if (!is_wp_error($temp_file)) {
            $wp_file_type = wp_check_filetype($temp_file);;
            $file = array(
                'name'     => basename($url),
                'type'     => $wp_file_type['type'],
                'tmp_name' => $temp_file,
                'error'    => 0,
                'size'     => filesize($temp_file),
            );

            $overrides = array(
                'test_form' => false,
                'test_size' => true,
            );

            return media_handle_sideload($file, $id, NULL, $overrides);
        }
    }


    public function importFromYouTube()
    {

        try {

            if (isset($_POST['provider']) && $_POST['provider'] === 'youtube') {

                foreach ($_POST['data'] as $key => $value) {

                    $id = wp_insert_post(array(
                        'post_title'    => $value['snippet']['title'],
                        'post_type'     => $_POST['content_type'],
                        'post_content'  => $value['snippet']['description'],
                        'post_status'   => 'publish'
                    ));

                    $thumbnail_post_id = $this->importUrlToMedia($value['snippet']['thumbnails']['medium']['url'], $id);


                    if ($_POST['content_type'] === 'movie') {
                        add_post_meta($id, '_' . $_POST['content_type'] . '_release_date',  current_time('timestamp'));
                        add_post_meta($id, '_' . $_POST['content_type'] . '_censor_rating',  '0.0');
                        add_post_meta($id, '_' . $_POST['content_type'] . '_run_time',  '0 hr : 0 min');
                        add_post_meta($id, '_imdb_id',  '0.0');
                    }

                    add_post_meta($id, '_thumbnail_id', $thumbnail_post_id);
                    add_post_meta($id, '_' . $_POST['content_type'] . '_choice', $_POST['content_type'] . '_embed');
                    add_post_meta($id, '_' . $_POST['content_type'] . '_embed_content', '<iframe width="1024" height="574" src="https://www.youtube.com/embed/' . $value['id']['videoId'] . '" allowfullscreen ></iframe>');
                }
            } elseif (isset($_POST['provider']) && $_POST['provider'] === 'vimeo') {

                foreach ($_POST['data'] as $key => $value) {

                    $id = wp_insert_post(array(
                        'post_title'    => $value['name'],
                        'post_type'     => $_POST['content_type'],
                        'post_content'  => $value['description'],
                        'post_status'   => 'publish'
                    ));

                    $position = strpos($value['pictures']['sizes'][8]['link'], "?");

                    $img_url = substr($value['pictures']['sizes'][8]['link'], 0, $position);

                    $thumbnail_post_id = $this->importUrlToMedia($img_url, $id);

                    if ($_POST['content_type'] === 'movie') {
                        add_post_meta($id, '_' . $_POST['content_type'] . '_release_date',  current_time('timestamp'));
                        add_post_meta($id, '_' . $_POST['content_type'] . '_censor_rating',  '0.0');
                        add_post_meta($id, '_' . $_POST['content_type'] . '_run_time',  '0 hr : 0 min');
                        add_post_meta($id, '_imdb_id',  '0.0');
                    }

                    add_post_meta($id, '_thumbnail_id', $thumbnail_post_id);
                    add_post_meta($id, '_' . $_POST['content_type'] . '_choice', $_POST['content_type'] . '_embed');
                    add_post_meta($id, '_' . $_POST['content_type'] . '_embed_content', $value['embed']['html']);
                }
            } elseif (isset($_POST['provider']) && $_POST['provider'] === 'omdb') {

                $auth_key = get_option('streamit_' . $_POST['provider'] . '_auth');

                foreach ($_POST['data'] as $key => $value) {

                    $curlLink =  'https://www.omdbapi.com/?apikey=' . $auth_key . '&type=' . $_POST['content_type'] . '&i=' . $value['imdbID'];

                    $apiResponse = wp_remote_get($curlLink);

                    $jsonArrayResponse = json_decode($apiResponse['body']);

                    if (count((array)$jsonArrayResponse) > 0) {

                        $id = wp_insert_post(array(
                            'post_title'    => $jsonArrayResponse->Title,
                            'post_type'     => $_POST['content_type'],
                            'post_content'  => $jsonArrayResponse->Plot,
                            'post_status'   => 'publish'
                        ));

                        $thumbnail_post_id = $this->importUrlToMedia($jsonArrayResponse->Poster, $id);

                        if ($_POST['content_type'] === 'movie') {
                            add_post_meta($id, '_thumbnail_id', $thumbnail_post_id);
                            add_post_meta($id, '_imdb_id',  $jsonArrayResponse->imdbID);
                            add_post_meta($id, '_' . $_POST['content_type'] . '_release_date',  strtotime($jsonArrayResponse->Released));
                            add_post_meta($id, '_' . $_POST['content_type'] . '_censor_rating',  '0.0');
                            add_post_meta($id, '_' . $_POST['content_type'] . '_run_time',  $jsonArrayResponse->Runtime);
                            add_post_meta($id, 'name_custom_imdb_rating', $jsonArrayResponse->imdbRating);


                            $movie_attr = $this->addMovieAttributes($jsonArrayResponse, 'omdb');
                            add_post_meta($id, '_movie_attributes', $movie_attr);
                        }
                    }
                }
            } elseif (isset($_POST['provider']) && $_POST['provider'] === 'csv') {

                if (isset($_POST['data']) && count($_POST['data']) > 0) {

                    foreach ($_POST['data'] as $key => $row) {

                        $id = wp_insert_post(array(
                            'post_title'    => $row[0],
                            'post_type'     => $_POST['content_type'],
                            'post_content'  => $row[1],
                            'post_status'   => 'publish'
                        ));

                        if ($_POST['content_type'] === 'movie') {
                            add_post_meta($id, '_imdb_id',  $row[4]);
                            add_post_meta($id, '_' . $_POST['content_type'] . '_release_date',  $row[2]);
                            add_post_meta($id, '_' . $_POST['content_type'] . '_censor_rating',  $row[5]);
                            add_post_meta($id, '_' . $_POST['content_type'] . '_run_time',    $row[3]);

                            $content_choice = [
                                'url' => "_{$_POST['content_type']}_url_link",
                                'embed' => "_{$_POST['content_type']}_embed_content"
                            ];
                            if (isset($content_choice[$row[6]])) {
                                add_post_meta($id, '_' . $_POST['content_type'] . '_choice', $_POST['content_type'] . '_' . $row[6]);
                                add_post_meta($id, $content_choice[$row[6]],  $row[7]);
                            }

                            $thumbnail_post_id = $this->importUrlToMedia($row[8], $id);
                            add_post_meta($id, '_thumbnail_id', $thumbnail_post_id);
                        }

                        if ($_POST['content_type'] === 'video') {

                            add_post_meta($id, '_' . $_POST['content_type'] . '_choice', $_POST['content_type'] . '_' . $row[2]);

                            if ($row[2] === 'embed') {
                                add_post_meta($id, '_' . $_POST['content_type'] . '_embed_content',  $row[3]);
                            }

                            if ($row[2] === 'url') {
                                add_post_meta($id, '_' . $_POST['content_type'] . '_url_link',  $row[3]);
                            }

                            $thumbnail_post_id = $this->importUrlToMedia($row[4], $id);
                            add_post_meta($id, '_thumbnail_id', $thumbnail_post_id);
                        }
                    }
                }
            } elseif (isset($_POST['provider']) && $_POST['provider'] === 'tmdb') {

                $auth_key = get_option('streamit_' . $_POST['provider'] . '_auth');
                $language = $_POST['language'];
                foreach ($_POST['data'] as $key => $value) {

                    $id = $value['id'];
                    $jsonArrayResponse = $this->streamit_tmdb_api($auth_key, $id, 'detail', $language);
                    $jsonArrayResponseCast = $this->streamit_tmdb_api($auth_key, $id, 'cast', $language);

                    $rating = $jsonArrayResponse->vote_average;

                    $genres_array = json_decode(json_encode($jsonArrayResponse), true);
                    $genres_array = $genres_array['genres'];

                    $cast_response = json_decode(json_encode($jsonArrayResponseCast), true);
                    $cast = [];

                    if (!empty($cast_response['cast'])) {
                        foreach ($cast_response['cast'] as $key => $cast_value) {
                            $temp['id'] = $this->addCast($cast_value, 'tmdb');
                            $temp['character'] = $cast_value['character'];
                            $temp['position'] = $key;
                            $cast[] = $temp;
                        }
                    }

                    $trailerJson = $this->streamit_tmdb_api($auth_key, $id, 'video', $language);

                    $siteType = $trailerJson->results[0]->site;

                    if (count((array)$jsonArrayResponse) > 0) {

                        $id = wp_insert_post(array(
                            'post_title' => $jsonArrayResponse->original_title,
                            'post_type' => $_POST['content_type'],
                            'post_content' => $jsonArrayResponse->overview,
                            'post_status' => 'publish'
                        ));

                        if (!empty($genres_array)) {
                            $term_id = 0;
                            $term_names = [];

                            foreach ($genres_array as $key => $genere_value) {
                                if (term_exists($genere_value['name'])) {
                                    $term = get_term(term_exists($genere_value['name']));
                                    $term_id = $term->term_id;
                                } else {
                                    $term_id = wp_insert_term($genere_value['name'], 'movie_genre', strtolower($genere_value['name']));
                                }
                                $term_names[] = $genere_value['name'];
                            }
                            wp_set_object_terms($id, $term_names, 'movie_genre');
                        }

                        $poster = 'https://image.tmdb.org/t/p/original' . $value['backdrop_path'];
                        $thumbnail_post_id = $this->importUrlToMedia($poster, $id);

                        if ($_POST['content_type'] === 'movie') {

                            add_post_meta($id, '_thumbnail_id', $thumbnail_post_id);
                            add_post_meta($id, '_imdb_id', $jsonArrayResponse->imdb_id);
                            add_post_meta($id, '_tmdb_id', $value['id']);
                            error_log(current_time($jsonArrayResponse->release_date));
                            add_post_meta($id, '_' . $_POST['content_type'] . '_release_date', strtotime($jsonArrayResponse->release_date));
                            add_post_meta($id, '_' . $_POST['content_type'] . '_censor_rating', '0.0');
                            add_post_meta($id, '_cast', $cast);
                            add_post_meta($id, '_crew', "");
                            add_post_meta($id, 'name_custom_imdb_rating', $rating);

                            if ($siteType === 'YouTube') {
                                add_post_meta($id, 'name_trailer_link', 'https://www.youtube.com/watch?v=' . $trailerJson->results[0]->key);
                            }

                            $hr = round($jsonArrayResponse->runtime / 60);
                            $min = ($jsonArrayResponse->runtime % 60);

                            add_post_meta($id, '_' . $_POST['content_type'] . '_run_time', $hr . 'hr : ' . $min . 'mins');
                            foreach ($cast as $cast_id) {
                                $cast_movie = get_post_meta($cast_id['id'], '_' . $_POST['content_type'] . '_cast', true);
                                if ($cast_movie == "") {
                                    add_post_meta($cast_id['id'], '_' . $_POST['content_type'] . '_cast', array($id));
                                } else {
                                    if (!in_array($cast_id['id'], $cast_movie)) {
                                        $cast_movie[] = $id;
                                        update_post_meta($cast_id['id'], '_' . $_POST['content_type'] . '_cast', $cast_movie);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            echo json_encode(array('status' => true, 'message' => 'Data import successfully.'));
            die;
        } catch (customException $e) {

            echo json_encode(array('status' => false, 'message' => 'Data not import successfully.'));
            die;
        }
    }

    public function readDataFromCsv()
    {

        $attachment_id = $_POST['attachment'];

        $attachment_url = wp_get_attachment_url($attachment_id);

        $_file = fopen($attachment_url, 'r');

        $lineNumber = 1;

        $data = [];

        while (($raw_string = fgets($_file)) !== false) {

            $row = str_getcsv($raw_string);

            if (count($row) > 0 && $lineNumber > 1) {
                $data[] = $row;
            }

            $lineNumber++;
        }

        wp_send_json(array('status' => true, 'message' => 'Data not import successfully.', 'data' => $data), 200);
    }

    public function streamit_tmdb_api($key, $id, $type, $language = "en")
    {
        $language = sanitize_text_field( wp_unslash( $language ));
        
        if ($type === "detail") {
            $curlLink = 'https://api.themoviedb.org/3/movie/' . $id . '?api_key=' . $key . '&language=' . $language;
        } elseif ($type === "video") {
            $curlLink = 'https://api.themoviedb.org/3/movie/' . $id . '/videos?api_key=' . $key . '&language=' . $language;
        } elseif ($type === "cast") {
            $curlLink = 'https://api.themoviedb.org/3/movie/' . $id . '/credits?api_key=' . $key . '&language=' . $language;
        }

        $response = wp_remote_get($curlLink);

        if (is_array($response) && is_wp_error($response)) {
            echo $response->get_error_message();
        }

        // $response = wp_remote_get($curlLink);
        $data = $response['body'];
        return json_decode($data);
    }

    public function addMovieAttributes($movieData, $provide)
    {
        if ($provide === 'omdb') {
            return [
                'director' => [
                    'name' => 'Director',
                    'value' => (!empty($movieData->Director) ? $movieData->Director : ''),
                    'position' => 0,
                    'is_visible' => 1,
                    'is_taxonomy' => 0
                ],
                'writer' => [
                    'name' => 'Writer',
                    'value' => (!empty($movieData->Writer) ? $movieData->Writer : ''),
                    'position' => 1,
                    'is_visible' => 1,
                    'is_taxonomy' => 0
                ],
                'actors' => [
                    'name' => 'Writer',
                    'value' => (!empty($movieData->Actors) ? $movieData->Actors : ''),
                    'position' => 2,
                    'is_visible' => 1,
                    'is_taxonomy' => 0
                ],
                'imdb-rating' => [
                    'name' => 'Imdb Rating',
                    'value' => (!empty($movieData->imdbRating) ? $movieData->imdbRating : ''),
                    'position' => 3,
                    'is_visible' => 1,
                    'is_taxonomy' => 0
                ],
                'box-Office' => [
                    'name' => 'Box Office',
                    'value' => (!empty($movieData->BoxOffice) ? $movieData->BoxOffice : ''),
                    'position' => 4,
                    'is_visible' => 1,
                    'is_taxonomy' => 0
                ],
                'released' => [
                    'name' => 'Released',
                    'value' => (!empty($movieData->Released) ? $movieData->Released : ''),
                    'position' => 5,
                    'is_visible' => 1,
                    'is_taxonomy' => 0
                ]
            ];
        }
    }

    public function addCast($castData, $provider)
    {

        if ($provider == 'tmdb') {
            global $wpdb;
            $query = 'SELECT ID FROM ' . $wpdb->prefix . 'posts WHERE post_title="' . $castData['original_name'] . '"';
            $results = $wpdb->get_var($query);

            if (empty($results)) {
                $id = wp_insert_post(array(
                    'post_title' => $castData['original_name'],
                    'post_type' => 'person',
                    'post_status' => 'publish'
                ));
                $poster = 'https://image.tmdb.org/t/p/original' . $castData['profile_path'];
                $thumbnail_post_id = $this->importUrlToMedia($poster, $id);
                add_post_meta($id, '_thumbnail_id', $thumbnail_post_id);
                return $id;
            } else {
                return $results;
            }
        }
    }
}
